#include <HardwareSerial.h>
#include "TinyGPS++.h"
#include "AsyncSMS.h"
#include "SIM.h" // Include library for SIM module, change the library name as needed

// Define Serial port for GPS
HardwareSerial gpsSerial(2); // Pins 43 (RX) and 44 (TX)

AsyncSMS smsHelper(&Serial, 4800);

TinyGPSPlus gps;

unsigned long lastSendTime = 0;
const unsigned long sendInterval = 60000; // Send location every 60 seconds

void setup() {
  Serial.begin(115200);
  gpsSerial.begin(9600, SERIAL_8N1, 43, 44);

  // Initialize SIM module
  SIM.begin(); // Replace with appropriate initialization function for your SIM module

  smsHelper.init();
  smsHelper.smsReceived = &messageReceived;
}

void loop() {
  // Check GSM network connection status
  if (SIM.isNetworkConnected()) {
    Serial.println("GSM module connected to network.");
  } else {
    Serial.println("GSM module not connected to network.");
  }

  while (gpsSerial.available() > 0) {
    if (gps.encode(gpsSerial.read())) {
      if (gps.location.isValid() && gps.location.age() < 2000) { // Ensure GPS data is valid and recent
        unsigned long currentMillis = millis();
        if (currentMillis - lastSendTime >= sendInterval) {
          sendLocationSMS(gps.location.lat(), gps.location.lng());
          lastSendTime = currentMillis;
        }
      }
    }
  }

  smsHelper.process();
}

void sendLocationSMS(float latitude, float longitude) {
  String locationURL = "https://www.google.com/maps?q=" + String(latitude, 6) + "," + String(longitude, 6);
  String message = "Current Location: " + locationURL;
  smsHelper.send("+7061350809", message.c_str(), 45);
}

void messageReceived(char * number, char * message) {
  if (strcmp(message, "get loc") == 0) {
    // "get loc" message received, send current location
    sendLocationSMS(gps.location.lat(), gps.location.lng());
  }
}
