
// Fault finder tool for electrical personnel.
// Written by: P.Balasubramanian.
// 30.9.2023.
//Digital pins PB3,4,6,7,8,9,10 and PA15 are 5V tolerant.
// Analog pin PA0 is standard 3.3V
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


int contact1 = PB3;//3;( For Arduino input)
byte contact1state;
byte lastcontact1state;
int VPin = PA0;     //A0;(Arduino analog input)

int contact2 = PB4;//4; (Arduino input)
byte contact2state;
byte lastcontact2state;

int contact3 = PA15; //5;(Arduino input)
byte contact3state;
byte lastcontact3state;

int contact4 = PB6;//6; (Arduino input)
byte contact4state;
byte lastcontact4state;

int contact5 = PB8;//7; (Arduino input)
byte contact5state;
byte lastcontact5state;

int contact6 = PB9;//8; (Arduino input)
byte contact6state;
byte lastcontact6state;

int contact7 = PB10;//9; (Arduino input)
byte contact7state;
byte lastcontact7state;

int stopcontact = PB7;//2; (Arduino input)
byte stopcontactstate;
byte laststopcontactstate;


void entry1() {
  Serial.print( "IN1 = ");
  Serial.print(contact1state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry2() {
  Serial.print( "IN2 = ");
  Serial.print(contact2state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry3() {
  Serial.print( "IN3 = ");
  Serial.print(contact3state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry4() {
  Serial.print( "IN4 = ");
  Serial.print(contact4state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry5() {
  Serial.print( "IN5 = ");
  Serial.print(contact5state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry6() {
  Serial.print( "IN6 = ");
  Serial.print(contact6state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void entry7() {
  Serial.print( "IN7 = ");
  Serial.print(contact7state);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());
}

void stoplogging() {
  Serial.print( "Final IN = ");
  Serial.print(stopcontactstate);
  Serial.print("; Time(msec)= ");
  Serial.println(millis());

}

void setup() {
  pinMode (contact1, INPUT);
  pinMode (contact2, INPUT);
  pinMode (contact3, INPUT);
  pinMode (contact4, INPUT);
  pinMode (contact5, INPUT);
  pinMode (contact6, INPUT);
  pinMode (contact7, INPUT);
  pinMode (stopcontact, INPUT);
  Serial.begin(2000000);
}

void loop () {

  float Vvalue = 3.3 * analogRead(VPin) / 4096.0; // (1024 for arduino)

  contact1state = digitalRead(contact1);
  contact2state = digitalRead(contact2);
  contact3state = digitalRead(contact3);
  contact4state = digitalRead(contact4);
  contact5state = digitalRead(contact5);
  contact6state = digitalRead(contact6);
  contact7state = digitalRead(contact7);
  stopcontactstate = digitalRead(stopcontact);

  if ( contact1state != lastcontact1state) {
    entry1();
    lastcontact1state = contact1state;
  }

  if ( contact2state != lastcontact2state) {
    entry2();
    lastcontact2state = contact2state;
  }

  if ( contact3state != lastcontact3state) {
    entry3();
    lastcontact3state = contact3state;
  }

  if ( contact4state != lastcontact4state) {
    entry4();
    lastcontact4state = contact4state;
  }

  if ( contact5state != lastcontact5state) {
    entry5();
    lastcontact5state = contact5state;
  }

  if ( contact6state != lastcontact6state) {
    entry6();
    lastcontact6state = contact6state;
  }

  if ( contact7state != lastcontact7state) {
    entry7();
    lastcontact7state = contact7state;
  }

  if ( stopcontactstate != laststopcontactstate) {
    stoplogging();
    laststopcontactstate = stopcontactstate;
  }

  if ((Vvalue < 1.0) || (Vvalue > 2.0))
  {
    Serial.print( "Voltage = ");
    Serial.print(Vvalue);
    Serial.print("; Time(msec)= ");
    Serial.println(millis());
    delay(100);
  }
  delay(10);
}
