import tkinter as tk
from tkinter import ttk
import serial
import matplotlib.pyplot as plt
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
import threading
import csv
import datetime
import time

# Function to establish serial connection with Arduino
def connect_to_arduino():
    while True:
        try:
            ser = serial.Serial('COM4', 9600)  # Adjust COM port accordingly
            return ser
        except serial.SerialException:
            print("Serial connection failed. Retrying in 2 seconds...")
            time.sleep(2)

# Function to read data from serial port
def read_data():
    while True:
        try:
            data = ser.readline().decode('utf-8').rstrip()
            if data and data[0].isdigit():  # Check if the line starts with a digit
                humidity, temperature = map(float, data.split())
                update_gui(humidity, temperature)
                update_plot(humidity, temperature)
                log_data(humidity, temperature)
        except Exception as e:
            print("Error:", e)
            break

# Function to update GUI with temperature and humidity readings
def update_gui(humidity, temperature):
    humidity_label.config(text=f'Temperature: {temperature}°C')
    temperature_label.config(text=f'Humidity: {humidity}%')

# Function to update plot
def update_plot(humidity, temperature):
    temperature_data.append(temperature)
    humidity_data.append(humidity)
    ax.clear()
    ax.plot(temperature_data, label='Temperature')
    ax.plot(humidity_data, label='Humidity')
    ax.legend()
    ax.grid(True)  # Add grid lines
    canvas.draw()

# Function to log data to CSV file with date and time
def log_data(humidity, temperature):
    now = datetime.datetime.now()
    timestamp = now.strftime("%Y-%m-%d %H:%M:%S")
    with open(r'E:/Orchid/EFY Project/sensor_data.csv', mode='a', newline='') as file:
        writer = csv.writer(file)
        writer.writerow([timestamp, humidity, temperature])

# Create GUI window
root = tk.Tk()
root.title("DHT11 Sensor Data")

# Create labels to display temperature and humidity
humidity_label = tk.Label(root, text="", font=("Arial", 12))
humidity_label.grid(row=0, column=0, padx=10, pady=5)

temperature_label = tk.Label(root, text="", font=("Arial", 12))
temperature_label.grid(row=1, column=0, padx=10, pady=5)

# Create plot
fig, ax = plt.subplots(figsize=(6, 4))
canvas = FigureCanvasTkAgg(fig, master=root)
canvas_widget = canvas.get_tk_widget()
canvas_widget.grid(row=0, column=1, rowspan=2, padx=10, pady=5)

# Initialize data lists for plotting
temperature_data = []
humidity_data = []

# Establish serial connection with Arduino
ser = connect_to_arduino()

# Start reading data from serial port in a separate thread
read_thread = threading.Thread(target=read_data)
read_thread.daemon = True  # Daemonize the thread so it automatically closes on program exit
read_thread.start()

# Run the Tkinter event loop
root.mainloop()
