#include "RMaker.h" 
#include "WiFi.h" 
#include "WiFiProv.h" 
#include "SimpleTimer.h" 
#include <wifi_provisioning/manager.h> 
// Set Default Values 
#define DEFAULT_RELAY_MODE false 
// BLE Credentils 
const char service_name = "********";//name 
const char *pop = "********";//password 
// GPIO 
static uint8_t gpio_reset = 0; 
static uint8_t relay = 27; 
bool relay_state = true; 
bool wifi_connected = 0; 
SimpleTimer Timer; 
static Switch my_switch("Kavish",&relay); 
void sysProvEvent(arduino_event_t *sys_event) { 
 switch (sys_event->event_id) { 
 case ARDUINO_EVENT_PROV_START: 
#if CONFIG_IDF_TARGET_ESP32S2
 Serial.printf("\nProvisioning Started with name \"%s\" and PoP \"%s\" on SoftAP\n",  service_name, pop); 
 printQR(service_name, pop, "softap"); 
#else 
 Serial.printf("\nProvisioning Started with name \"%s\" and PoP \"%s\" on BLE\n",  service_name, pop); 
 printQR(service_name, pop, "ble"); 
#endif 
 break; 
 break; 
 case ARDUINO_EVENT_WIFI_STA_CONNECTED: 
 Serial.printf("\nConnected to Wi-Fi!\n"); 
 wifi_connected = 1; 
 delay(500); 
 break; 
 case ARDUINO_EVENT_PROV_CRED_RECV: 
 { 
 Serial.println("\nReceived Wi-Fi credentials"); 
 Serial.print("\tSSID : "); 
 Serial.println((const char *)sys_event->event_info.prov_cred_recv.ssid);  Serial.print("\tPassword : "); 
 Serial.println((char const *)sys_event->event_info.prov_cred_recv.password);  break; 
 } 
 case ARDUINO_EVENT_PROV_INIT: 
 wifi_prov_mgr_disable_auto_stop(10000); 
 break; 
 case ARDUINO_EVENT_PROV_CRED_SUCCESS: 
 Serial.println("Stopping Provisioning!!!"); 
 wifi_prov_mgr_stop_provisioning(); 
 break; 
 } 
} 
void write_callback(Device *device, Param *param, const param_val_t val, void *priv_data,  write_ctx_t *ctx) { 
 const char *device_name = device->getDeviceName(); 
 Serial.println(device_name); 
 const char *param_name = param->getParamName(); 
 if (strcmp(param_name, "Power") == 0) { 
 if (strcmp(param_name, "Power") == 0) { 
 Serial.printf("Received value = %s for %s - %s\n", val.val.b ? "true" : "false",  device_name, param_name); 
 relay_state = val.val.b; 
 (relay_state == false) ? digitalWrite(relay, HIGH) : digitalWrite(relay, LOW);  param->updateAndReport(val); 
 } 
 } 
} 
void setup() { 
 Serial.begin(115200);
 pinMode(gpio_reset, INPUT); 
 pinMode(relay, OUTPUT); 
 digitalWrite(relay, DEFAULT_RELAY_MODE); 
 //--------------------------------- Declaring Node ----------------------------------------------//  Node my_node; 
 my_node = RMaker.initNode("Hotspot_Charging"); 
 //Standard switch device 
 my_switch.addCb(write_callback); 
 //------------------------------ Adding Devices in Node --------------------------------------//  my_node.addDevice(my_switch); 
 WiFi.onEvent(sysProvEvent); 
 //This is optional 
 RMaker.enableOTA(OTA_USING_PARAMS); 
 RMaker.enableTZService(); 
 RMaker.enableSchedule(); 
 Serial.printf("\nStarting ESP-RainMaker\n"); 
 RMaker.start(); 
 // Timer for Sending Sensor's Data 
 Timer.setInterval(3000); 
#if CONFIG_IDF_TARGET_ESP32 
 WiFiProv.beginProvision(WIFI_PROV_SCHEME_BLE,  
WIFI_PROV_SCHEME_HANDLER_FREE_BTDM, WIFI_PROV_SECURITY_1, pop,  service_name); 
#else 
 WiFiProv.beginProvision(WIFI_PROV_SCHEME_SOFTAP,  
WIFI_PROV_SCHEME_HANDLER_NONE, WIFI_PROV_SECURITY_1, pop,  service_name); 
#endif 
} 
void loop() { 
 if (Timer.isReady() && wifi_connected) {  
 Timer.reset();  
 } // Read GPIO0 (external button to reset device 
 if (digitalRead(gpio_reset) == LOW) { //Push button pressed 
 Serial.printf("Reset Button Pressed!\n"); 
 // Key debounce handling 
 delay(100); 
 int startTime = millis(); 
 while (digitalRead(gpio_reset) == LOW) 
 delay(50); 
 int endTime = millis(); 
 if ((endTime - startTime) > 10000) { 
 // If key pressed for more than 10secs, reset all 
 Serial.printf("Reset to factory.\n"); 
 wifi_connected = 0; 
 RMakerFactoryReset(2); 
 } else if ((endTime - startTime) > 3000) { 
 Serial.printf("Reset Wi-Fi.\n"); 
 wifi_connected = 0;
 // If key pressed for more than 3secs, but less than 10, reset Wi-Fi  RMakerWiFiReset(2); 
 } 
 } 
 delay(100); 
} 
