#include <TFT_eSPI.h>
#include <TinyGPS++.h>
#include <SPI.h>
#include <Wire.h>
#include <CST816S.h>

TFT_eSPI tft = TFT_eSPI();
TFT_eSprite sprite = TFT_eSprite(&tft);
TinyGPSPlus gps;
CST816S touch(5, 6, 10, 7);

#define WIDTH 240
#define HEIGHT 240

#define PI 3.1415926535897932384626433832795

int radius = 60; // Radius of the Earth sphere
float theta = 0; // Angle for rotation
float speed = 0.01; // Speed of rotation
unsigned long lastUpdate = 0;
int currentSatelliteIndex = 0;
int screen = 0; // Current screen (0 for globe, 1 for satellite info)

void setup() {
  Serial.begin(115200);

  // Initialize TFT display
  tft.init();
  tft.setRotation(0); // Set portrait orientation
  tft.fillScreen(TFT_BLACK);

  // Initialize sprite
  sprite.createSprite(WIDTH, HEIGHT);

  // Initialize GPS (ensure correct pins are set for your GPS module)
  Serial1.begin(9600); // Assuming GPS is connected to Serial1

  // Initialize touch
  touch.begin();
}

void loop() {
  // Handle touch gestures for screen switching
  if (touch.available()) {
     if(touch.gesture()="SWIPE LEFT"){
      screen = (screen + 1) % 2;
    } else {
      screen = (screen - 1 + 2) % 2;
    }
  }

  // Clear the sprite
  sprite.fillSprite(TFT_BLACK);
  
  if (screen == 0) {
    // Screen 0: Draw Earth sphere and satellite
    drawEarth();
    drawSatellite();
  } else {
    // Screen 1: Display satellite information
    displayGPSInfo();
  }

  // Push the sprite to the TFT display
  sprite.pushSprite(0, 0);

  // Rotate the Earth sphere if on screen 0
  if (screen == 0) {
    theta += speed;
  }

  // Delay to slow down rotation and touch processing
  delay(50);
}

void drawEarth() {
int globeCenterX = WIDTH / 2;
  int globeCenterY = HEIGHT / 2;  // Center vertically and horizontally
  int globeRadius = radius + 26;  // Increase radius by 4 pixels

  for (int i = 0; i < 360; i += 10) {
    for (int j = -90; j < 90; j += 10) {
      float phi = i * PI / 180;
      float gamma = j * PI / 180;
      float nextPhi = (i + 10) * PI / 180;
      float nextGamma = (j + 10) * PI / 180;
      
      // 3D coordinates
      float x1 = globeRadius * cos(gamma) * cos(phi);
      float y1 = globeRadius * cos(gamma) * sin(phi);
      float z1 = globeRadius * sin(gamma);

      float x2 = globeRadius * cos(gamma) * cos(nextPhi);
      float y2 = globeRadius * cos(gamma) * sin(nextPhi);
      float z2 = globeRadius * sin(gamma);

      float x3 = globeRadius * cos(nextGamma) * cos(phi);
      float y3 = globeRadius * cos(nextGamma) * sin(phi);
      float z3 = globeRadius * sin(nextGamma);

      // Rotation around the Y axis
      float x1_rot = x1 * cos(theta) - z1 * sin(theta);
      float z1_rot = x1 * sin(theta) + z1 * cos(theta);

      float x2_rot = x2 * cos(theta) - z2 * sin(theta);
      float z2_rot = x2 * sin(theta) + z2 * cos(theta);

      float x3_rot = x3 * cos(theta) - z3 * sin(theta);
      float z3_rot = x3 * sin(theta) + z3 * cos(theta);

      // Projection to 2D plane
      float x1_2d = globeCenterX + x1_rot;
      float y1_2d = globeCenterY + y1;

      float x2_2d = globeCenterX + x2_rot;
      float y2_2d = globeCenterY + y2;

      float x3_2d = globeCenterX + x3_rot;
      float y3_2d = globeCenterY + y3;

      // Draw lines
      sprite.drawLine(x1_2d, y1_2d, x2_2d, y2_2d, TFT_WHITE);
      sprite.drawLine(x1_2d, y1_2d, x3_2d, y3_2d, TFT_WHITE);
    }
  }
}

void drawSatellite() {
  // Satellite parameters
  float satelliteRadius = radius + 20 + 20; // Distance from the Earth center
  float satelliteAngle = theta * 2; // Satellite rotation speed
  
  // 3D coordinates of the satellite
  float x_sat = satelliteRadius * cos(satelliteAngle);
  float y_sat = satelliteRadius * sin(satelliteAngle);
  
  // Projection to 2D plane
  float x_sat_2d = WIDTH / 2 + x_sat;
  float y_sat_2d = HEIGHT / 2 + y_sat; // Center vertically and horizontally
  
  // Draw satellite (simple rectangle as a placeholder)
  sprite.fillRect(x_sat_2d - 5, y_sat_2d - 5, 10, 10, TFT_WHITE);
  
  // Draw orbit ring
  sprite.drawCircle(WIDTH / 2, HEIGHT / 2, satelliteRadius, TFT_WHITE);
}

void displayGPSInfo() {
  sprite.setTextColor(TFT_WHITE, TFT_BLACK);
  sprite.setFreeFont(&FreeSans9pt7b); // Using FreeSansBold12pt7b font
  sprite.setCursor(0,20); // Moved text further down

  if (gps.satellites.isValid()) {
    sprite.printf("Total Satellites: %d\n", gps.satellites.value());

    unsigned long currentTime = millis();
    if (currentTime - lastUpdate > 2000) {
      currentSatelliteIndex++;
      if (currentSatelliteIndex >= gps.satellites.value()) {
        currentSatelliteIndex = 0;
      }
      lastUpdate = currentTime;
    }

    sprite.setCursor(0, HEIGHT / 3 + 40); // Adjusted cursor position for satellite details
    // Displaying data for one satellite at a time
    sprite.printf("S%d ID: %d\n", currentSatelliteIndex + 1, currentSatelliteIndex + 1); // Placeholder ID
    sprite.printf("S%d AZ: %.2f\n", currentSatelliteIndex + 1, currentSatelliteIndex * 10.0); // Placeholder Azimuth
    sprite.printf("S%d EL: %.2f\n", currentSatelliteIndex + 1, currentSatelliteIndex * 5.0); // Placeholder Elevation
  } else {
    sprite.printf("Total Satellites: --\n");
  }
}
