#include <TFT_eSPI.h>
#include <TinyGPS++.h>
#include <SPI.h>
#include <Wire.h>

TFT_eSPI tft = TFT_eSPI();
TFT_eSprite sprite = TFT_eSprite(&tft);
TinyGPSPlus gps;

#define WIDTH 240
#define HEIGHT 240

#define PI 3.1415926535897932384626433832795

int radius = 60; // Increased radius of the Earth sphere
float theta = 0; // Angle for rotation
float speed = 0.01; // Speed of rotation
unsigned long lastUpdate = 0;
int currentSatelliteIndex = 0;

void setup() {
  Serial.begin(115200);

  // Initialize TFT display
  tft.init();
  tft.setRotation(0); // Set portrait orientation
  tft.fillScreen(TFT_BLACK);

  // Initialize sprite
  sprite.createSprite(WIDTH, HEIGHT);

  // Initialize GPS (ensure correct pins are set for your GPS module)
  Serial1.begin(9600); // Assuming GPS is connected to Serial1
}

void loop() {
  while (Serial1.available() > 0) {
    gps.encode(Serial1.read());
  }

  // Clear the sprite
  sprite.fillSprite(TFT_BLACK);
  
  // Draw Earth sphere and satellite
  drawEarth();
  drawSatellite();

  // Display satellite information
  displayGPSInfo();

  // Push the sprite to the TFT display
  sprite.pushSprite(0, 0);

  // Rotate the Earth sphere
  theta += speed;

  // Delay to slow down rotation
  delay(50);
}

void drawEarth() {
  for (int i = 0; i < 360; i += 10) {
    for (int j = -90; j < 90; j += 10) {
      float phi = i * PI / 180;
      float gamma = j * PI / 180;
      float nextPhi = (i + 10) * PI / 180;
      float nextGamma = (j + 10) * PI / 180;
      
      // 3D coordinates
      float x1 = radius * cos(gamma) * cos(phi);
      float y1 = radius * cos(gamma) * sin(phi);
      float z1 = radius * sin(gamma);

      float x2 = radius * cos(gamma) * cos(nextPhi);
      float y2 = radius * cos(gamma) * sin(nextPhi);
      float z2 = radius * sin(gamma);

      float x3 = radius * cos(nextGamma) * cos(phi);
      float y3 = radius * cos(nextGamma) * sin(phi);
      float z3 = radius * sin(nextGamma);

      // Rotation around the Y axis
      float x1_rot = x1 * cos(theta) - z1 * sin(theta);
      float z1_rot = x1 * sin(theta) + z1 * cos(theta);

      float x2_rot = x2 * cos(theta) - z2 * sin(theta);
      float z2_rot = x2 * sin(theta) + z2 * cos(theta);

      float x3_rot = x3 * cos(theta) - z3 * sin(theta);
      float z3_rot = x3 * sin(theta) + z3 * cos(theta);

      // Projection to 2D plane
      float x1_2d = WIDTH / 2 + x1_rot;
      float y1_2d = HEIGHT / 3 + y1; // Moved further down

      float x2_2d = WIDTH / 2 + x2_rot;
      float y2_2d = HEIGHT / 3 + y2; // Moved further down

      float x3_2d = WIDTH / 2 + x3_rot;
      float y3_2d = HEIGHT / 3 + y3; // Moved further down

      // Draw lines
      sprite.drawLine(x1_2d, y1_2d, x2_2d, y2_2d, TFT_WHITE);
      sprite.drawLine(x1_2d, y1_2d, x3_2d, y3_2d, TFT_WHITE);
    }
  }
}

void drawSatellite() {
  // Satellite parameters
  float satelliteRadius = radius + 20; // Distance from the Earth center
  float satelliteAngle = theta * 2; // Satellite rotation speed
  
  // 3D coordinates of the satellite
  float x_sat = satelliteRadius * cos(satelliteAngle);
  float y_sat = satelliteRadius * sin(satelliteAngle);
  
  // Projection to 2D plane
  float x_sat_2d = WIDTH / 2 + x_sat;
  float y_sat_2d = HEIGHT / 3 + y_sat; // Moved further down
  
  // Draw satellite (simple rectangle as a placeholder)
  sprite.fillRect(x_sat_2d - 5, y_sat_2d - 5, 10, 10, TFT_WHITE);
  
  // Optionally, you can draw a line representing the orbit
  sprite.drawCircle(WIDTH / 2, HEIGHT / 3, satelliteRadius, TFT_WHITE);
}

void displayGPSInfo() {
  sprite.setTextColor(TFT_WHITE, TFT_BLACK);
  sprite.setTextSize(1);
  sprite.setCursor(0, HEIGHT / 2 + 50); // Moved text further down

  if (gps.satellites.isValid()) {
    sprite.printf("Total Satellites: %d\n", gps.satellites.value());

    unsigned long currentTime = millis();
    if (currentTime - lastUpdate > 2000) {
      currentSatelliteIndex++;
      if (currentSatelliteIndex >= gps.satellites.value()) {
        currentSatelliteIndex = 0;
      }
      lastUpdate = currentTime;
    }

    sprite.setCursor(0, HEIGHT / 2 + 70); // Adjusted cursor position for satellite details
    // Displaying data for one satellite at a time
    sprite.printf("S%d ID: %d\n", currentSatelliteIndex + 1, currentSatelliteIndex + 1); // Placeholder ID
    sprite.printf("S%d AZ: %.2f\n", currentSatelliteIndex + 1, currentSatelliteIndex * 10.0); // Placeholder Azimuth
    sprite.printf("S%d EL: %.2f\n", currentSatelliteIndex + 1, currentSatelliteIndex * 5.0); // Placeholder Elevation
  } else {
    sprite.printf("Total Satellites: --\n");
  }
}
