#include <SPI.h>
#include <MFRC522.h>
#include <WiFi.h>
#include <WebServer.h>
#include <time.h>


// RFID pin configuration
#define RST_PIN    6
#define SS_PIN     34


MFRC522 mfrc522(SS_PIN, RST_PIN);  // Create MFRC522 instance


// Wi-Fi credentials
const char* ssid = "your_SSID";
const char* password = "your_PASSWORD";


WebServer server(80);


// Data structures
struct Person {
 String uid;
 String time;
 bool inside;  // true for entered, false for exited
};


Person persons[10];  // Max 10 people for this example
int totalEntered = 0;


void setup() {
 Serial.begin(9600);
 SPI.begin();
 mfrc522.PCD_Init();
  // Connect to Wi-Fi
 WiFi.begin(ssid, password);
 while (WiFi.status() != WL_CONNECTED) {
   delay(500);
   Serial.print(".");
 }
 Serial.println("WiFi connected.");
  // Start the web server
 server.on("/", handleRoot);
 server.begin();
 Serial.println("Web server started.");
  // Initialize data
 for (int i = 0; i < 10; i++) {
   persons[i].uid = "";
   persons[i].inside = false;
 }
}


void loop() {
 // Handle incoming RFID card scans
 if (mfrc522.PICC_IsNewCardPresent() && mfrc522.PICC_ReadCardSerial()) {
   String uid = "";
   for (byte i = 0; i < mfrc522.uid.size; i++) {
     uid += String(mfrc522.uid.uidByte[i] < 0x10 ? "0" : "") + String(mfrc522.uid.uidByte[i], HEX);
   }
   uid.toUpperCase();
   Serial.println(uid);
  
   // Handle the entry/exit
   handleEntryExit(uid);
  
   // Halt the PICC
   mfrc522.PICC_HaltA();
 }


 // Handle web server requests
 server.handleClient();
}


// Function to handle entry or exit of a person based on their RFID
void handleEntryExit(String uid) {
 bool found = false;
 for (int i = 0; i < 10; i++) {
   if (persons[i].uid == uid) {
     found = true;
     // If already inside, mark as exit
     if (persons[i].inside) {
       persons[i].inside = false;
       totalEntered--;
       persons[i].time = getCurrentTime();
     } else {
       // If exiting, mark as entered
       persons[i].inside = true;
       totalEntered++;
       persons[i].time = getCurrentTime();
     }
     break;
   }
 }
  // If not found, mark as new entry
 if (!found) {
   for (int i = 0; i < 10; i++) {
     if (persons[i].uid == "") {
       persons[i].uid = uid;
       persons[i].inside = true;
       persons[i].time = getCurrentTime();
       totalEntered++;
       break;
     }
   }
 }
}


// Function to serve the web page
void handleRoot() {
 String html = "<html><head><title>Entry-Exit Monitoring</title></head><body>";
 html += "<h1>Entry and Exit Monitoring System</h1>";
 html += "<table border='1'><tr><th>RFID UID</th><th>Status</th><th>Time</th></tr>";
  for (int i = 0; i < 10; i++) {
   if (persons[i].uid != "") {
     html += "<tr><td>" + persons[i].uid + "</td><td>";
     if (persons[i].inside) {
       html += "<span style='color:green;'>Entered</span>";
     } else {
       html += "<span style='color:red;'>Exited</span>";
     }
     html += "</td><td>" + persons[i].time + "</td></tr>";
   }
 }
  html += "</table>";
 html += "<h2>Total Entered: " + String(totalEntered) + "</h2>";
 html += "</body></html>";
  server.send(200, "text/html", html);
}


// Function to get current time in a readable format
String getCurrentTime() {
 struct tm timeinfo;
 if (!getLocalTime(&timeinfo)) {
   return "Time Error";
 }
 char timeString[20];
 strftime(timeString, sizeof(timeString), "%H:%M:%S", &timeinfo);
 return String(timeString);
}
