#define RefreshTime 5 // Adjusted delay of 5 seconds

#define D_22 22 // 
#define D_23 23 // 
#define D_25_A28 25 // ADC 28
#define D_26_A29 26 // ADC 29
#define D_27_A27 27 // ADC 27
#define TX_0 01 // 
#define RX_0 03 //
#define D_21 21 //
#define D_19 19 // 
#define D_18 18 // 
#define D_05 05 // 
#define TX_2 17 // 
#define RX_2 16 // 
#define D_04_A20 04 // ADC 20
#define D_02_A22 02 // ADC 22
#define D_15_A23 15 // ADC 23 
#define D_12_A25 12 // ADC 25
#define D_13_A24 13 // ADC 24
#define D_14_A26 14 // ADC 26
#define V_P_A10 36 // ADC 10
#define V_N_A13 39 // ADC 13
#define D_32_A14 32 // ADC 14
#define D_33_A15 33 // ADC 15
#define D_34_A16 34 // ADC 16
#define D_35_A17 35 // ADC 17

#include <WiFi.h>             
#include "Adafruit_MQTT.h"           
#include "Adafruit_MQTT_Client.h"    

#define WLAN_SSID       "ABCDEFGHI"                           
#define WLAN_PASS       "12345678"                        
#define AIO_SERVER      "io.adafruit.com"                    
#define AIO_SERVERPORT  1883                                 
#define AIO_USERNAME    "Abcdefghi_123"                          
#define AIO_KEY         "aio_yUFq50H1pi3aSqrlZaiObrRJm"   

WiFiClient client;
Adafruit_MQTT_Client mqtt(&client, AIO_SERVER, AIO_SERVERPORT, AIO_USERNAME, AIO_KEY);          
Adafruit_MQTT_Publish Feed1 = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/Current");  
Adafruit_MQTT_Publish Feed2 = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/voltage");  
Adafruit_MQTT_Publish Feed3 = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/Celsius");      
Adafruit_MQTT_Publish Feed4 = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/level");     
Adafruit_MQTT_Publish Feed5 = Adafruit_MQTT_Publish(&mqtt, AIO_USERNAME "/feeds/state");     

void MQTT_connect();           

#include <LiquidCrystal.h>
LiquidCrystal lcd( D_05, D_18,  D_19, D_21,  D_22,  D_23);

#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 25
float Celsius = 0;
OneWire oneWire(ONE_WIRE_BUS);       
DallasTemperature sensors(&oneWire); 

const int trigPin = 4;     
const int echoPin = 2;
long duration;             
double level, distanceCm; 
float TankHeight = 30;

const int sensorIn = 32; 
int mVperAmp = 100; 
double Voltage = 0;
double VRMS = 0;
double Current = 0;

float getVPP()
{
  float result;
  int readValue; 
  int maxValue = 0; 
  int minValue = 4096.0; 
  uint32_t start_time = millis();
  while ((millis() - start_time) < 2000) 
  {
    readValue = analogRead(sensorIn);
    if (readValue > maxValue)
    {
      maxValue = readValue;
    }
    if (readValue < minValue)
    {
      minValue = readValue;
    }
  }
  result = ((maxValue - minValue) * 3.33) / 4096.0;
  return result;
}

float voltagevalue = D_35_A17;        
float sensorvalue;              
float voltage;                  
float r1 = 47000.0;             
float r2 = 10000.0;             
int   state;

void setup() {
  sensors.begin();
  lcd.begin(16, 2);
  lcd.setCursor(0, 0);            
  lcd.print("     19U620 "); 
  lcd.setCursor(0, 1);            
  lcd.print("INNOVATION PRACTICES"); 
  delay(1000);                    
  lcd.clear();                    

  pinMode(trigPin, OUTPUT);       
  pinMode(echoPin, INPUT);        
  Serial.begin(115200);
  delay(10);
  WiFi.begin(WLAN_SSID, WLAN_PASS);     
  if (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print("."); 
  }
}

void loop() {
  sensors.requestTemperatures();
  Celsius = sensors.getTempCByIndex(0);

  digitalWrite(trigPin, LOW);                 
  delayMicroseconds(2);                       
  digitalWrite(trigPin, HIGH);                
  delayMicroseconds(10);                      
  digitalWrite(trigPin, LOW);
  duration = pulseIn(echoPin, HIGH);          
  distanceCm = (duration * 0.034 / 2) - 3;        
  if (distanceCm < 0) {
    distanceCm = 0;
  }
  if (distanceCm > TankHeight) {
    distanceCm = TankHeight;
  }
  level = abs((((distanceCm / TankHeight) * 100) - 100));

  sensorvalue = analogRead(voltagevalue);                     
  voltage =  (sensorvalue * (5.0 / 1024) * ((r1 + r2) / r2)) * 0.1475; 

  Voltage = getVPP();
  VRMS = (Voltage / 2.0) * 0.707; 
  Current = (VRMS * 1000) / mVperamp - 0.9;

  lcd.clear();
  lcd.setCursor(0, 0);             
  lcd.print("I=");                 
  lcd.setCursor(5, 0);             
  lcd.print("mA");                 
  lcd.setCursor(2, 0);             
  lcd.print(Current, 2);          
  lcd.setCursor(0 , 1);           
  lcd.print("V=");                
  lcd.setCursor(5 , 1);           
  lcd.print("V");                 
  lcd.setCursor(2, 1);            
  lcd.print(voltage, 2);          
  lcd.setCursor(10, 0);          
  lcd.print("T=");               
  lcd.setCursor(15, 0);          
  lcd.print("C");                
  lcd.setCursor(12, 0);          
  lcd.print(Celsius);           
  lcd.setCursor(10, 1);         
  lcd.print("L=");              
  lcd.setCursor(14, 1);         
  lcd.print("%");               
  lcd.setCursor(12, 1);         
  lcd.print(level, 0); 

  MQTT_connect(); 

  if (! Feed1.publish(Current))   {
    Serial.println(F("Failed"));     
  }
  else  {
    Serial.println(F("OK!"));        
  }
  if (! Feed2.publish(voltage))   {
    Serial.println(F("Failed"));    
  }
  else  {
    Serial.println(F("OK!"));       
  }
  if (! Feed3.publish(Celsius))   {
    Serial.println(F("Failed"));    
  }
  else {
    Serial.println(F("OK!"));       
  }
  if (! Feed4.publish(level))   {
    Serial.println(F("Failed"));    
  }
  else {
    Serial.println(F("OK!"));       
  }
  delay(RefreshTime * 1000);                     
}
void MQTT_connect()
{
  int8_t ret;
  if (mqtt.connected())
  {
    return;
  }
  uint8_t retries = 3;
  if ((ret = mqtt.connect()) != 0)
  {
    mqtt.disconnect();
    delay(5000); 
    retries--;
  }
} 


