#include <Adafruit_FONA.h>
int sospin = 29;  // Analog input 0 of your Arduino
#define FONA_RST 4
char replybuffer[255];
// Create a HardwareSerial object
HardwareSerial fonaSerial(1);  // UART1 for ESP32-S2
Adafruit_FONA fona = Adafruit_FONA(FONA_RST);
uint8_t readline(char *buff, uint8_t maxbuff, uint16_t timeout = 0);
void setup() {
 Serial.begin(9600);  // Start the serial monitor communication
 pinMode(sospin, INPUT);
 // Initialize fonaSerial with the desired RX and TX pins
 fonaSerial.begin(4800, SERIAL_8N1, 43, 44);  // 4800 baud, RX = 43, TX = 44


 if (!fona.begin(fonaSerial)) {
   Serial.println(F("Couldn't find FONA"));
   while (1);
 }
 Serial.println(F("FONA is OK"));


 // Print SIM card IMEI number
 char imei[16] = {0};  // MUST use a 16-character buffer for IMEI!
 uint8_t imeiLen = fona.getIMEI(imei);
 if (imeiLen > 0) {
   Serial.print("SIM card IMEI: ");
   Serial.println(imei);
 }


 fonaSerial.print("AT+CNMI=2,1\r\n");
 Serial.println("FONA Ready");


 char fonaNotificationBuffer[64];  // For notifications from the FONA
 char smsBuffer[250];              // Buffer to store SMS
}


void loop() {
 if (analogRead(sospin) >= 500) {
   Serial.println("Alert in danger ");
   if (!fona.sendSMS("7979952235", "Hey, This Loved One in Danger Emergency Help Needed")) {
     Serial.println(F("Failed"));
   } else {
     Serial.println(F("Sent!"));
     delay(4000);
   }
 } else {
   digitalWrite(19, HIGH);
   delay(300);
 }
}


