#include <Wire.h>
#include "MAX30100_PulseOximeter.h"

#define REPORTING_PERIOD_MS 1000  // Reporting period for heart rate and SpO2

// PulseOximeter object for sensor interface
PulseOximeter pox;

uint32_t tsLastReport = 0;

// Callback function fired when a pulse is detected
void onBeatDetected()
{
    Serial.println("Beat Detected!");
}

void setup()
{
    // Initialize Serial for debugging and data output
    Serial.begin(9600);

    Serial.println("Initializing pulse oximeter...");
    
    // Initialize the PulseOximeter instance
    // Failures could be due to incorrect I2C wiring or wrong sensor initialization
    if (!pox.begin()) {
        Serial.println("Pulse Oximeter initialization FAILED");
        while (true);  // Halt the system if initialization fails
    } else {
        Serial.println("Pulse Oximeter initialization SUCCESS");
    }
      pox.setIRLedCurrent(MAX30100_LED_CURR_7_6MA);
    // Set the beat detection callback
    pox.setOnBeatDetectedCallback(onBeatDetected);
}

void loop()
{
    // Update sensor readings
    pox.update();

    // Report heart rate and SpO2 every second
    if (millis() - tsLastReport > REPORTING_PERIOD_MS) {
        // Print heart rate (BPM) and SpO2 (Oxygen saturation percentage)
        Serial.print("Heart Rate (BPM): ");
        Serial.print(pox.getHeartRate());
        Serial.print(" | SpO2 (%): ");
        Serial.println(pox.getSpO2());

        tsLastReport = millis();  // Update the last reporting time
    }
}
