const int sensorL1 = 2;   // Lowest sensor
const int sensorL2 = 3;   // Middle sensor
const int sensorL3 = 4;   // Highest sensor
const int LEDL1 = 8;      // Lowest level LED
const int LEDL2 = 9;      // Middle level LED
const int LEDL3 = 10;     // Highest level LED
const int relayPin = 11;  // Relay control pin
// Pump state variable
bool pumpOn = false; // Tracks whether the pump should be ON or OFF
void setup() {
  // Configure sensor pins as input
  pinMode(sensorL1, INPUT);
  pinMode(sensorL2, INPUT);
  pinMode(sensorL3, INPUT);
  // Configure LED and relay pins as output
  pinMode(LEDL1, OUTPUT);
  pinMode(LEDL2, OUTPUT);
  pinMode(LEDL3, OUTPUT);
  pinMode(relayPin, OUTPUT);
  // Initialize the relay (pump OFF)
  digitalWrite(relayPin, LOW);
}
void loop() {
  // Read sensor values
  bool levelL1 = digitalRead(sensorL1);
  bool levelL2 = digitalRead(sensorL2);
  bool levelL3 = digitalRead(sensorL3);
  // Filling Logic
  if (!levelL1 && !levelL2 && !levelL3) {
    // Water below lowest sensor
    pumpOn = true;         // Turn pump ON
  } 
  else if (levelL3) {
    // Water reaches highest sensor
    pumpOn = false;        // Turn pump OFF
  }
  // Update Relay State
  digitalWrite(relayPin, pumpOn ? HIGH : LOW);
  // LED Indicators
  if (levelL1 && !levelL2 && !levelL3) {
    // Water touches lowest sensor
    digitalWrite(LEDL1, HIGH); // LED 1 ON
    digitalWrite(LEDL2, LOW);  // LED 2 OFF
    digitalWrite(LEDL3, LOW);  // LED 3 OFF
  } 
  else if (levelL2 && !levelL3) {
    // Water touches middle sensor
    digitalWrite(LEDL1, LOW);  // LED 1 OFF
    digitalWrite(LEDL2, HIGH); // LED 2 ON
    digitalWrite(LEDL3, LOW);  // LED 3 OFF
  } 
  else if (levelL3) {
    // Water touches highest sensor
    digitalWrite(LEDL1, LOW);  // LED 1 OFF
    digitalWrite(LEDL2, LOW);  // LED 2 OFF
    digitalWrite(LEDL3, HIGH); // LED 3 ON
  } 
  else {
    // All sensors inactive (below lowest sensor)
    digitalWrite(LEDL1, LOW);  // LED 1 OFF
    digitalWrite(LEDL2, LOW);  // LED 2 OFF
    digitalWrite(LEDL3, LOW);  // LED 3 OFF
  }
}
