#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <RTClib.h>
#include <EEPROM.h>
#include <Keypad.h>

#define relayPin 10
#define buzzerPin A0
#define maxBells 10
int hourupg;
int minupg;
int yearupg;
int monthupg;
int dayupg;
int dowupg;
int Noofbellsaddr = 0;
int Noofbells;
int hours[20];
int mins[20];

RTC_DS3231 rtc;
LiquidCrystal_I2C lcd(0x27, 16, 2);

const byte ROWS = 4; 
const byte COLS = 4;
char keys[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};
byte rowPins[ROWS] = {9, 8, 7, 6};
byte colPins[COLS] = {5, 4, 3, 2};
Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);

struct BellTime {
  byte hour;
  byte minute;
};
BellTime bellSchedule[maxBells];
byte numBells = 0;

void setup() {
  Serial.begin(9600);
  Wire.begin();
  lcd.begin(16,2);
  lcd.backlight();

  pinMode(relayPin, OUTPUT);
  pinMode(buzzerPin, OUTPUT);
  digitalWrite(relayPin, LOW);

  if (!rtc.begin()) {
    lcd.print("RTC ERROR");
    while (1);
  }
  rtc.adjust(DateTime(__DATE__, __TIME__));
  lcd.print("CLG BELL SYSTEM");
  delay(2000);
  lcd.clear();
  loadBellSchedule();
}

void loop() {
  DateTime now = rtc.now();
  lcd.setCursor(0, 0);
  lcd.print(now.year(), DEC);
  lcd.print("/");
  lcd.print(now.month(), DEC);
  lcd.print("/");
  lcd.print(now.day(), DEC);

  lcd.setCursor(0, 1);
  lcd.print(now.hour(), DEC);
  lcd.print(":");
  lcd.print(now.minute(), DEC);
  lcd.print(":");
  lcd.print(now.second(), DEC);

  for (byte i = 0; i < numBells; i++) {
    if (bellSchedule[i].hour == now.hour() && bellSchedule[i].minute == now.minute()) {
      ringBell();
    }
  }

  char key = keypad.getKey();
  if (key == '*') {
    menu();
  }
  delay(1000);
}

void ringBell() {
  digitalWrite(relayPin, HIGH);
  digitalWrite(buzzerPin, HIGH);
  delay(10000);
  digitalWrite(relayPin, LOW);
  digitalWrite(buzzerPin, LOW);
}

void menu() {
  lcd.clear();
  lcd.print("1:Set Time");
  lcd.setCursor(0, 1);
  lcd.print("2:Set Bells");
  delay(1000);
  char key = keypad.waitForKey();
  if (key == '1') {
    setTime();
  } else if (key == '2') {
    setBellSchedule();
  }
}

void setTime() {
  lcd.clear();
  lcd.print("Set Year:");
  int year = getNumber();
  lcd.clear();
  lcd.print("Set Month:");
  int month = getNumber();
  lcd.clear();
  lcd.print("Set Day:");
  int day = getNumber();
  lcd.clear();
  lcd.print("Set Hour:");
  int hour = getNumber();
  lcd.clear();
  lcd.print("Set Minute:");
  int minute = getNumber();
  rtc.adjust(DateTime(year, month, day, hour, minute, 0));
}

void setBellSchedule() {
  lcd.clear();
  lcd.print("No of Bells:");
  numBells = getNumber();
  for (byte i = 0; i < numBells; i++) {
    lcd.clear();
    lcd.print("Bell "); lcd.print(i + 1);
    lcd.setCursor(0, 1);
    lcd.print("Hour:");
    bellSchedule[i].hour = getNumber();
    lcd.clear();
    lcd.print("Minute:");
    bellSchedule[i].minute = getNumber();
  }
  saveBellSchedule();
}

int getNumber() {
  String input = "";
  while (true) {
    char key = keypad.getKey();
    if (key) {
      if (key == '#') break;
      if (isdigit(key)) {
        input += key;
        lcd.print(key);
      }
    }
  }
  return input.toInt();
}

void saveBellSchedule() {
  EEPROM.write(0, numBells);
  for (byte i = 0; i < numBells; i++) {
    EEPROM.write(i * 2 + 1, bellSchedule[i].hour);
    EEPROM.write(i * 2 + 2, bellSchedule[i].minute);
  }
}

void loadBellSchedule() {
  numBells = EEPROM.read(0);
  for (byte i = 0; i < numBells; i++) {
    bellSchedule[i].hour = EEPROM.read(i * 2 + 1);
    bellSchedule[i].minute = EEPROM.read(i * 2 + 2);
  }
}