#define BP 4 // Button pin 
#define L1 12 // BIT 1 (MSB) 
#define L2 13 // BIT 2 
#define L3 14 // BIT 3 (LSB) 
#define ID 50 // Initial delay 
#define FD 300 // Final delay 
#define RS 40 // Rolling steps 
void setup() { 
pinMode(L1, OUTPUT); 
pinMode(L2, OUTPUT); 
pinMode(L3, OUTPUT); 
pinMode(BP, INPUT); 
Serial.begin(115200); 
} 

void loop() { 
if (digitalRead(BP) == HIGH) { 
int dt = ID; 
for (int i = 0; i < RS; i++) { 
int rn = (i % 6) + 1; 
displayNum(rn); 
delay(dt);
dt = map(i, 0, RS - 1, ID, FD); 
} 
int r = random(1, 7); 
displayNum(r); 
} 
} 
void displayNum(int n){ 
digitalWrite(L1, (n & 0b100) ? HIGH : LOW); 
digitalWrite(L2, (n & 0b010) ? HIGH : LOW); 
digitalWrite(L3, (n & 0b001) ? HIGH : LOW); 
}
