#include <LiquidCrystal.h>

// Pin definitions
#define VIBRATION_PIN_ANALOG A0
#define VIBRATION_PIN_DIGITAL 8
#define LM35_PIN A1
#define BUZZER_PIN 9
#define RELAY_PIN 10
#define PIR_PIN 7  // PIR sensor pin

// Threshold values (Adjust based on your lathe machine conditions)
#define VIBRATION_THRESHOLD_ANALOG 512  // Analog vibration sensor threshold
#define VIBRATION_THRESHOLD_DIGITAL 1  // Digital vibration sensor threshold (1 means vibration detected)
#define TEMPERATURE_THRESHOLD 30       // Temperature threshold (°C)
#define MOTION_DETECTED 1              // Motion detection threshold for PIR sensor

// Create an LCD object (RS, E, D4, D5, D6, D7)
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

void setup() {
  // Initialize LCD
  lcd.begin(16, 2);
  Serial.begin(9600);  
  // Initialize pins
  pinMode(VIBRATION_PIN_DIGITAL, INPUT);
  pinMode(PIR_PIN, INPUT);  // PIR sensor as input
  pinMode(BUZZER_PIN, OUTPUT);
  pinMode(RELAY_PIN, OUTPUT);

  // Display initial message
  lcd.print("System Ready...");                            Serial.print("Yogesh jatav" );
  delay(2000);  // Show message for 2 seconds
}

void loop() {
  // Read vibration sensor (Analog)
  int vibrationAnalog = analogRead(VIBRATION_PIN_ANALOG);

  // Read vibration sensor (Digital)
  int vibrationDigital = digitalRead(VIBRATION_PIN_DIGITAL);

  // Read temperature from LM35 sensor
  int tempReading = analogRead(LM35_PIN);
  float temperature = (tempReading / 1024.0) * 5000.0;  // Convert to millivolts
  temperature = temperature / 10;  // Convert to Celsius (LM35 gives 10mV per °C)

  // Read PIR motion sensor (HIGH indicates motion detected)
  int motionDetected = digitalRead(PIR_PIN);

  // Check if vibration exceeds threshold (for analog or digital sensor)
  if (vibrationAnalog > VIBRATION_THRESHOLD_ANALOG || vibrationDigital == VIBRATION_THRESHOLD_DIGITAL) {
    digitalWrite(BUZZER_PIN, HIGH);  // Turn on buzzer
    digitalWrite(RELAY_PIN, HIGH);   // Activate relay (could be for external systems like stopping machine)
  } else {
    digitalWrite(BUZZER_PIN, LOW);   // Turn off buzzer
    digitalWrite(RELAY_PIN, LOW);    // Deactivate relay
  }

  // Check if the temperature exceeds the threshold
  if (temperature > TEMPERATURE_THRESHOLD) {
    digitalWrite(BUZZER_PIN, HIGH);  // Turn on buzzer for high temperature
    digitalWrite(RELAY_PIN, HIGH);   // Trigger relay for cooling or emergency shutdown
  }

  // Check if motion is detected by the PIR sensor
  if (motionDetected == MOTION_DETECTED) {
    digitalWrite(BUZZER_PIN, HIGH);  // Turn on buzzer to alert motion detected
    digitalWrite(RELAY_PIN, HIGH);   // Trigger relay (this could activate a system based on motion)
  } else {
    // Motion not detected, turn off buzzer and relay
    digitalWrite(BUZZER_PIN, LOW);
    digitalWrite(RELAY_PIN, LOW);
  }

  // Display data on the LCD
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Vib: ");
  lcd.print(vibrationAnalog);  // Display vibration value (analog sensor reading)

  lcd.setCursor(0, 1);
  lcd.print("Temp: ");
  lcd.print(temperature);      // Display temperature in Celsius
  lcd.print(" C");

  // Optionally, you could add another line to display motion detection status
  if (motionDetected == MOTION_DETECTED) {
    lcd.setCursor(0, 1);
    lcd.print("Motion Detected!");
  }

  delay(1000);  // Update every second
}
