//   STA mode   but accepts connections  //
//   static ip  // 
//   Port forwarding  //

#include <WiFi.h>

// choose a port number as mentioned in the text //
#define EspListenPort xxxxx   

// Replace with your router credentials
const char* ssid = ".............." ;   // 
const char* password = ".........." ;

WiFiServer server( EspListenPort );  // STA mode  //

// Set your Static IP address for ESP. See text //
// Octet are separated by comma and not dot //
IPAddress localIP( xxx, xxx, xxx, xxx ); 
IPAddress gateway( xxx, xxx, xxx, xxx);
IPAddress subnet( xxx, xxx, xxx, xxx);

WiFiClient client ;
char ch ;

// LED on GPIO4
int ledPin = 4;

void setup() {
    // Set LED as output
    pinMode(ledPin, OUTPUT);

  Serial.begin(115200);

  // Configures static IP address : STA mode //
  if (!WiFi.config(localIP, gateway, subnet)) {
     Serial.println("STA Failed to configure");
  }
  
  // Connect to Wi-Fi network with SSID and password
  Serial.print("Connecting to ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  // Print local IP address and start web server
  Serial.println("");
  Serial.println("WiFi connected.");
  Serial.print ("IP address: ");
  Serial.println(WiFi.localIP());
  server.begin();
}

void loop() {
    //  ESP32 Listens for incoming clients  // 
    //  ESP in STA mode but listens  //
    client = server.available();  

  if (client) {    // If a new client connects,
    
      while (client.connected()) { 

          if (client.available()) {    
              ch = client.read();         
              Serial.write(ch);
              switch (ch) {
                case '1':
                  client.println ( "ON" ) ;
                  break;
                case '2':
                  client.println ( "OFF" ) ;
                  break;
              }
          }
                 
          switch ( ch ) {
              case '1':
                  digitalWrite(ledPin, HIGH);  
                  break ;

              case '2':
                  digitalWrite(ledPin, LOW);             
                  break ; 
              } 
       }
  }
    delay (500);
}
