#include <PID_v1.h>

// PID Variables
double Setpoint, Input, Output;
double Kp = 2.0, Ki = 0.5, Kd = 1.0;
PID myPID(&Input, &Output, &Setpoint, Kp, Ki, Kd, DIRECT);

// Encoder Feedback
volatile long encoderPos = 0;
void updateEncoder() {
  encoderPos++;
}

void setup() {
  // Initialize PID
  Setpoint = 1000; // Desired position
  myPID.SetMode(AUTOMATIC);

  // Attach Encoder Interrupt
  attachInterrupt(digitalPinToInterrupt(2), updateEncoder, RISING);

  // Initialize Serial for Monitoring
  Serial.begin(9600);
}

void loop() {
  // Read Encoder Position
  Input = encoderPos;

  // Compute PID
  myPID.Compute();

  // Drive Stepper Motor
  analogWrite(9, Output);

  // Monitor Temperature and Current
  float temperature = analogRead(A0) * 0.488; // LM35
  float current = (analogRead(A1) - 512) * 0.185; // ACS712

  // Predictive Failure Logic
  if (temperature > 60.0 || current > 1.5) {
    Serial.println("Warning: Motor failure predicted!");
  }

  // Serial Output for Monitoring
  Serial.print("Position: ");
  Serial.print(encoderPos);
  Serial.print(" Temperature: ");
  Serial.print(temperature);
  Serial.print(" Current: ");
  Serial.println(current);

  delay(100);
}
