#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Keypad.h>
#include <math.h>  // Include math functions
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define BUTTON_PIN 10  // Push button for switching modes
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);
// Keypad Configuration
const byte ROWS = 4;
const byte COLS = 4;
char keys[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};
byte rowPins[ROWS] = {9, 8, 7, 6};
byte colPins[COLS] = {5, 4, 3, 2};
Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);
String input = "";
char lastOperator = '\0';
float num1 = 0, num2 = 0;
bool isNewNumber = true;
bool scientificMode = false;  // Toggle between normal and scientific mode
void setup() {
  Serial.begin(9600);
  pinMode(BUTTON_PIN, INPUT_PULLUP);  // Internal pull-up resistor
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    Serial.println(F("SSD1306 initialization failed"));
    for (;;);
  }
  displayWelcomeMessage();
}
void loop() {
  // Check if the button is pressed
  if (digitalRead(BUTTON_PIN) == LOW) {
    delay(300);  // Debounce delay
    scientificMode = !scientificMode;  // Toggle mode
    showScientificMessage();
  }
  char key = keypad.getKey();
  if (key) {
    if (key == '*') {  
      // Fix: Clear screen should work in both modes
      input = "";
      num1 = num2 = 0;
      lastOperator = '\0';
      isNewNumber = true;
      displayResult("");  // Ensure screen is cleared
      return;  // Stop further processing
    }
    if (key >= '0' && key <= '9') {
      if (isNewNumber) {
        input = "";
        isNewNumber = false;
      }
      input += key;
    }
    else if (!scientificMode && (key == 'A' || key == 'B' || key == 'C' || key == 'D')) {
      // Normal Mode: Arithmetic operations
      if (input.length() > 0) {
        num1 = input.toFloat();
        if (key == 'A') lastOperator = '*';
        else if (key == 'B') lastOperator = '+';
        else if (key == 'C') lastOperator = '-';
        else if (key == 'D') lastOperator = '/';
        isNewNumber = true;
      }
    }
    else if (!scientificMode && key == '#') {
      // Normal Mode: Perform arithmetic calculation
      if (input.length() > 0 && lastOperator != '\0') {
        num2 = input.toFloat();
        float result = calculate(num1, num2, lastOperator);
        input = String(result);
        isNewNumber = true;
        lastOperator = '\0';
      }
    }
    else if (scientificMode && (key == 'A' || key == 'B' || key == 'C' || key == 'D')) {
      // Scientific Mode Calculations
      if (input.length() > 0) {
        float value = input.toFloat();
        float result = 0;
        if (key == 'A') result = sin(value * (PI / 180.0));  // sin()
        else if (key == 'B') result = cos(value * (PI / 180.0));  // cos()
        else if (key == 'C') result = tan(value * (PI / 180.0));  // tan()
        else if (key == 'D') result = sqrt(value);  // sqrt()
        input = String(result, 4);
        isNewNumber = true;
      }
    }
    displayResult(input);
  }
}
float calculate(float n1, float n2, char op) {
  switch (op) {
    case '+': return n1 + n2;
    case '-': return n1 - n2;
    case '*': return n1 * n2;
    case '/': return (n2 != 0) ? n1 / n2 : 0;
    default: return 0;
  }
}
void displayResult(String text) {
  display.clearDisplay();
  display.setCursor(5, 20);
  display.setTextSize(2);
  display.print(text);
  display.display();
}
void displayWelcomeMessage() {
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(10, 10);
  display.print("Calculator");
  display.display();
  delay(2000);
  display.clearDisplay();
}
void showScientificMessage() {
  display.clearDisplay();
  display.setCursor(10, 20);
  display.setTextSize(2);
  display.print(scientificMode ? "Scientific Mode" : "Calculator");
  display.display();
  delay(1000);
}
