#include "DFRobot_GR10_30.h"
#include <Wire.h>

#define RELAY_1 2
#define RELAY_2 3
#define RELAY_3 4
#define RELAY_4 5

DFRobot_GR10_30 gr10_30(/*addr = */GR10_30_DEVICE_ADDR, /*pWire = */&Wire);

int x = 1;  // Initial position

void setup() {
  Serial.begin(115200);
  while (gr10_30.begin() != 0) {
    Serial.println("Sensor initialize failed!!");
    delay(1000);
  }
  Serial.println("Sensor initialize success!!");

  gr10_30.enGestures(GESTURE_LEFT | GESTURE_RIGHT | GESTURE_UP | GESTURE_DOWN);

  pinMode(RELAY_1, OUTPUT);
  pinMode(RELAY_2, OUTPUT);
  pinMode(RELAY_3, OUTPUT);
  pinMode(RELAY_4, OUTPUT);
  
  digitalWrite(RELAY_1, HIGH);
  digitalWrite(RELAY_2, HIGH);
  digitalWrite(RELAY_3, HIGH);
  digitalWrite(RELAY_4, HIGH);
}

void loop() {
  if (gr10_30.getDataReady()) {
    uint16_t gestures = gr10_30.getGesturesState();
    
    if (gestures & GESTURE_RIGHT) {
      if (x < 4) {
        x++;
      } else {
        x = 1; // Reset to 1 if at 4
      }
      Serial.print("Position: "); Serial.println(x);
    }
    
    if (gestures & GESTURE_LEFT) {
      if (x > 1) {
        x--;
      } else {
        x = 4; // Reset to 4 if at 1
      }
      Serial.print("Position: "); Serial.println(x);
    }
    
    if (gestures & GESTURE_DOWN) {
      Serial.print("Relay ON at position: "); Serial.println(x);
      controlRelay(x, LOW); // Turn ON relay
    }
    
    if (gestures & GESTURE_UP) {
      Serial.print("Relay OFF at position: "); Serial.println(x);
      controlRelay(x, HIGH); // Turn OFF relay
    }
  }
  delay(1);
}

void controlRelay(int position, int state) {
  switch (position) {
    case 1: digitalWrite(RELAY_1, state); break;
    case 2: digitalWrite(RELAY_2, state); break;
    case 3: digitalWrite(RELAY_3, state); break;
    case 4: digitalWrite(RELAY_4, state); break;
  }
}
