#include <DHT.h>
#define DHTPIN 2
#define DHTTYPE DHT22
DHT dht(DHTPIN, DHTTYPE);

int relayPin = 7; // Connected to the relay module
float humidityThreshold = 55.0; // Set required humidity level

void setup() {
  Serial.begin(9600);
  dht.begin();
  pinMode(relayPin, OUTPUT);
  digitalWrite(relayPin, HIGH); // Keep relay off initially
}

void loop() {
  float humidity = dht.readHumidity();
  Serial.print("Humidity: ");
  Serial.println(humidity);

  if (humidity < humidityThreshold) {
    digitalWrite(relayPin, LOW); // Turn on humidifier
  } else {
    digitalWrite(relayPin, HIGH); // Turn off humidifier
  }

  delay(5000); // Wait 5 seconds before next reading
}
