#include <SPI.h>
#include <MFRC522.h>
#include <WiFi.h>
#include <WebServer.h>


#define RST_PIN         6
#define SS_PIN          34


MFRC522 mfrc522(SS_PIN, RST_PIN);


MFRC522::MIFARE_Key key;


const char* ssid = "YOUR_SSID";
const char* password = "YOUR_PASSWORD";


WebServer server(80);


void setup() {
   Serial.begin(115200);
   while (!Serial);


   SPI.begin();
   mfrc522.PCD_Init();


   for (byte i = 0; i < 6; i++) {
       key.keyByte[i] = 0xFF;
   }


   WiFi.begin(ssid, password);
   while (WiFi.status() != WL_CONNECTED) {
       delay(500);
       Serial.print(".");
   }
   Serial.println("Connected to WiFi");


   server.on("/", HTTP_GET, handleRoot);
   server.begin();
}


void loop() {
   server.handleClient();


   if (!mfrc522.PICC_IsNewCardPresent())
       return;


   if (!mfrc522.PICC_ReadCardSerial())
       return;


   Serial.print("Card UID: ");
   dump_byte_array(mfrc522.uid.uidByte, mfrc522.uid.size);
   Serial.println();


   byte sector = 1;
   byte blockAddr = 4;
   byte dataBlock[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0xff, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f};
   byte trailerBlock = 7;
   MFRC522::StatusCode status;
   byte buffer[18];
   byte size = sizeof(buffer);


   status = mfrc522.PCD_Authenticate(MFRC522::PICC_CMD_MF_AUTH_KEY_A, trailerBlock, &key, &(mfrc522.uid));
   if (status != MFRC522::STATUS_OK) {
       Serial.print("PCD_Authenticate() failed: ");
       Serial.println(mfrc522.GetStatusCodeName(status));
       return;
   }


   status = mfrc522.MIFARE_Read(blockAddr, buffer, &size);
   if (status != MFRC522::STATUS_OK) {
       Serial.print("MIFARE_Read() failed: ");
       Serial.println(mfrc522.GetStatusCodeName(status));
   }
   Serial.print("Data in block ");
   Serial.print(blockAddr);
   Serial.println(":");
   dump_byte_array(buffer, 16);
   Serial.println();


   status = mfrc522.MIFARE_Write(blockAddr, dataBlock, 16);
   if (status != MFRC522::STATUS_OK) {
       Serial.print("MIFARE_Write() failed: ");
       Serial.println(mfrc522.GetStatusCodeName(status));
   }


   mfrc522.PICC_HaltA();
   mfrc522.PCD_StopCrypto1();
}


void handleRoot() {
   String html = "<!DOCTYPE html><html><head><title>Smart Metro System</title><style>body {font-family: Arial, sans-serif;margin: 20px;background-color: #f4f4f4;}h1 {color: #333;}table {width: 100%;border-collapse: collapse;margin-bottom: 20px;}table, th, td {border: 1px solid #ddd;}th, td {padding: 10px;text-align: center;}th {background-color: #f2f2f2;}</style></head><body><h1>Smart Metro System</h1><table><thead><tr><th>Card UID</th><th>Remaining Balance</th></tr></thead><tbody><tr><td>";


   // Assuming you want to display the last read card UID and a fixed balance for now
   html += String(mfrc522.uid.uidByte[0], HEX) + " " + String(mfrc522.uid.uidByte[1], HEX) + " " + String(mfrc522.uid.uidByte[2], HEX) + " " + String(mfrc522.uid.uidByte[3], HEX);
   html += "</td><td>50</td></tr></tbody></table></body></html>";


   server.send(200, "text/html", html);
}


void dump_byte_array(byte *buffer, byte bufferSize) {
   for (byte i = 0; i < bufferSize; i++) {
       Serial.print(buffer[i] < 0x10 ? " 0" : " ");
       Serial.print(buffer[i], HEX);
   }
}



