#include <Wire.h>
#include "MAX30100_PulseOximeter.h"
#include <Health_Analomy_inferencing.h>  // Replace with your downloaded Edge Impulse library header

////////////edge-impulse-data-forwarder --clean////
#define FREQUENCY_HZ        50
#define INTERVAL_MS         (1000 / (FREQUENCY_HZ + 1))
#define ANOMALY_THRESHOLD   0.3f  // Adjust based on your model's performance

static unsigned long last_interval_ms = 0;
static unsigned long inference_count = 0;

// Pulse Oximeter
PulseOximeter pox;
bool pulse_sensor_detected = false;

// Buffer for features (size depends on your EI model: num_features * num_samples)
float features[EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE];
int sample_count = 0;

void setup() {
    Serial.begin(115200);
    Serial.println("Started");

    // Initialize I2C bus.
    Wire.begin();

    // Initialize Pulse Oximeter
    if (pox.begin()) {
        pulse_sensor_detected = true;
        Serial.println("PulseOximeter sensor found.");
    } else {
        Serial.println("PulseOximeter sensor not found. Using simulated values.");
        randomSeed(analogRead(0));  // Seed for random number generator
    }

    Serial.println("Pulse Oximeter initialized");
    Serial.println("Edge Impulse model initialized");
}

void loop() {
    // Update Pulse Oximeter only if detected
    if (pulse_sensor_detected) {
        pox.update();
    }

    if (millis() > last_interval_ms + INTERVAL_MS) {
        last_interval_ms = millis();
        
        // Read heart rate and SpO2
        float hr, spo2;
        if (pulse_sensor_detected) {
            hr = pox.getHeartRate();
            spo2 = pox.getSpO2();
        } else {
            // Simulated random values in normal healthy range
           hr = random(60, 100) / 100.0f;  // 60-100 bpm, as float
            spo2 = random(95, 100) / 100.0f;  // 95-100%, as float
        }
        
        // Collect features into buffer (assuming order: hr, spo2 per sample)
        // Adjust index based on your model's expected feature order and frame size
        int feature_idx = sample_count * 2;  // 2 features per sample
        if (feature_idx + 1 < EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE) {
            features[feature_idx] = hr;
            features[feature_idx + 1] = spo2;
            sample_count++;
        }
        
        // Run inference when buffer is full
        if (sample_count >= (EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE / 2)) {  // Full window
            signal_t signal;
            numpy::signal_from_buffer(features, EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE, &signal);
            ei_impulse_result_t result = { 0 };
            
            EI_IMPULSE_ERROR res = run_classifier(&signal, &result, false);
            inference_count++;
            
            if (res != EI_IMPULSE_OK) {
                Serial.printf("ERR: Failed to run classifier (%d)\n", res);
                return;
            }
            
            // Print predictions if any
            Serial.printf("Predictions (DSP: %d ms., Classification: %d ms., Anomaly: %d ms.):\n",
                          result.timing.dsp, result.timing.classification, result.timing.anomaly);
            for (size_t ix = 0; ix < EI_CLASSIFIER_LABEL_COUNT; ix++) {
                Serial.printf("%s: %.5f\n", result.classification[ix].label, result.classification[ix].value);
            }
            
            // Check anomaly score
            Serial.printf("Anomaly score: %.3f\n", result.anomaly);
            if (result.anomaly > ANOMALY_THRESHOLD) {
                Serial.println("HEALTH ANOMALY DETECTED!");
                // Add your anomaly response here, e.g., alert, log, etc.
            } else {
                Serial.println("Normal health data.");
            }
            
            int total = result.timing.dsp + result.timing.classification + result.timing.anomaly;
            Serial.printf("Inference took %d ms (%.2f Hz)\n\n", 
                          total, 1000.0f / total);
            
            // Reset buffer for next inference
            sample_count = 0;
            memset(features, 0, sizeof(features));
        }
        
        // Print current health data for monitoring
      //  Serial.print("HR: ");
      //  Serial.print(hr);
     //   Serial.print(" bpm, SpO2: ");
    //    Serial.print(spo2);
     //   Serial.println("%");
    }
}