#include <Wire.h>
#include <LSM303AGR_ACC_Sensor.h>
#include "MAX30100_PulseOximeter.h"
////////////edge-impulse-data-forwarder --clean////
#define CONVERT_G_TO_MS2    9.80665f
#define FREQUENCY_HZ        50
#define INTERVAL_MS         (1000 / (FREQUENCY_HZ + 1))
static unsigned long last_interval_ms = 0;
// Components for the LSM303
LSM303AGR_ACC_Sensor Acc(&Wire);
// Pulse Oximeter
PulseOximeter pox;
void setup() {
    Serial.begin(115200);
    Serial.println("Started");

    // Initialize I2C bus.
    Wire.begin();

    // Initialize LSM303 accelerometer
    Acc.begin();
    Acc.Enable();
    Acc.EnableTemperatureSensor();

    // Initialize Pulse Oximeter
    if (!pox.begin()) {
        Serial.println("PulseOximeter sensor not found. Halting.");
        while (1);
    }

    Serial.println("LSM303 Accelerometer and Pulse Oximeter initialized");
}
void loop() {
    // Update Pulse Oximeter continuously
    pox.update();

    int32_t accelerometer[3];
    if (millis() > last_interval_ms + INTERVAL_MS) {
        last_interval_ms = millis();
        // Read accelerometer data
        Acc.GetAxes(accelerometer);
        // Convert to m/s^2
        float ax = accelerometer[0] * CONVERT_G_TO_MS2 / 1000.0f;
        float ay = accelerometer[1] * CONVERT_G_TO_MS2 / 1000.0f;
        float az = accelerometer[2] * CONVERT_G_TO_MS2 / 1000.0f;
        // Read heart rate and SpO2 (last known values)
        float hr = pox.getHeartRate();
        float spo2 = pox.getSpO2();
        // Print all data tab-separated
        //Serial.print(ax);
       // Serial.print('\t');
      //  Serial.print(ay);
      //  Serial.print('\t');
     //   Serial.print(az);
     //   Serial.print('\t');
        Serial.print(hr);
        Serial.print('\t');
        Serial.println(spo2);
    }
}