/*
 * Copyright (c) 2025 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */

#ifndef _EI_CLASSIFIER_MODEL_VARIABLES_H_
#define _EI_CLASSIFIER_MODEL_VARIABLES_H_

/**
 * @file
 *  Auto-generated complete impulse definitions. The ei_impulse_handle_t should
 *  be passed to ei_run_classifier() function to use this specific impulse.
 *  This file should only be included in ei_run_classifier.h file.
 */

#include <stdint.h>
#include "model_metadata.h"
#include "anomaly_metadata.h"
#include "tflite-model/tflite_anomaly_791007_6_compiled.h"
#include "edge-impulse-sdk/classifier/ei_model_types.h"
#include "edge-impulse-sdk/classifier/inferencing_engines/engines.h"
#include "edge-impulse-sdk/classifier/postprocessing/ei_postprocessing_common.h"

const char* ei_classifier_inferencing_categories_791007_1[] = { "anomaly" };

EI_CLASSIFIER_DSP_AXES_INDEX_TYPE ei_dsp_config_791007_4_axes[] = { 0, 1 };
const uint32_t ei_dsp_config_791007_4_axes_size = 2;
ei_dsp_config_raw_t ei_dsp_config_791007_4 = {
    4, // uint32_t blockId
    1, // int implementationVersion
    2, // int length of axes
    1.0f // float scale-axes
};

const uint8_t ei_dsp_blocks_791007_1_size = 1;
ei_model_dsp_t ei_dsp_blocks_791007_1[ei_dsp_blocks_791007_1_size] = {
    { // DSP block 4
        4,
        100, // output size
        &extract_raw_features, // DSP function pointer
        (void*)&ei_dsp_config_791007_4, // pointer to config struct
        ei_dsp_config_791007_4_axes, // array of offsets into the input stream, one for each axis
        ei_dsp_config_791007_4_axes_size, // number of axes
        1, // version
        nullptr, // factory function
        nullptr, // data normalization config
    }
};
const ei_config_tflite_eon_graph_t ei_config_graph_791007_6 = {
    .implementation_version = 1,
    .model_init = &tflite_anomaly_791007_6_init,
    .model_invoke = &tflite_anomaly_791007_6_invoke,
    .model_reset = &tflite_anomaly_791007_6_reset,
    .model_input = &tflite_anomaly_791007_6_input,
    .model_output = &tflite_anomaly_791007_6_output,
};

ei_learning_block_config_anomaly_gmm_t ei_learning_block_config_791007_6 = {
    .implementation_version = 1,
    .block_id = 6,
    .anom_axis = ei_classifier_anom_axes_791007_6,
    .anom_axes_size = 19,
    .graph_config = (void*)&ei_config_graph_791007_6
};

const uint8_t ei_learning_blocks_791007_1_size = 1;
const uint32_t ei_learning_block_791007_6_inputs[1] = { 4 };
const uint8_t ei_learning_block_791007_6_inputs_size = 1;
const ei_learning_block_t ei_learning_blocks_791007_1[ei_learning_blocks_791007_1_size] = {
    {
        6,
        &run_gmm_anomaly,
        (void*)&ei_learning_block_config_791007_6,
        EI_CLASSIFIER_IMAGE_SCALING_NONE,
        ei_learning_block_791007_6_inputs,
        ei_learning_block_791007_6_inputs_size,
    },
};


const size_t ei_postprocessing_blocks_791007_1_size = 1;
const ei_postprocessing_block_t ei_postprocessing_blocks_791007_1[ei_postprocessing_blocks_791007_1_size] = {
    {
        .block_id = 6,
        .type = EI_CLASSIFIER_MODE_ANOMALY_GMM,
        .init_fn = NULL,
        .deinit_fn = NULL,
        .postprocess_fn = &process_anomaly,
        .display_fn = NULL,
        .config = NULL,
        .input_block_id = 6
    },
};

const ei_impulse_t impulse_791007_1 = {
    .project_id = 791007,
    .project_owner = "Ashwini",
    .project_name = "Health_Analomy",
    .impulse_id = 1,
    .impulse_name = "Impulse #1",
    .deploy_version = 1,

    .nn_input_frame_size = 100,
    .raw_sample_count = 50,
    .raw_samples_per_frame = 2,
    .dsp_input_frame_size = 50 * 2,
    .input_width = 0,
    .input_height = 0,
    .input_frames = 0,
    .interval_ms = 20,
    .frequency = 50,

    .dsp_blocks_size = ei_dsp_blocks_791007_1_size,
    .dsp_blocks = ei_dsp_blocks_791007_1,

    .learning_blocks_size = ei_learning_blocks_791007_1_size,
    .learning_blocks = ei_learning_blocks_791007_1,

    .postprocessing_blocks_size = ei_postprocessing_blocks_791007_1_size,
    .postprocessing_blocks = ei_postprocessing_blocks_791007_1,

    .inferencing_engine = EI_CLASSIFIER_TFLITE,

    .sensor = EI_CLASSIFIER_SENSOR_FUSION,
    .fusion_string = "hr + spo2",
    .slice_size = (50/4),
    .slices_per_model_window = 4,

    .has_anomaly = EI_ANOMALY_TYPE_GMM,
    .label_count = 1,
    .categories = ei_classifier_inferencing_categories_791007_1
};

ei_impulse_handle_t impulse_handle_791007_1 = ei_impulse_handle_t( &impulse_791007_1 );
ei_impulse_handle_t& ei_default_impulse = impulse_handle_791007_1;
constexpr auto& ei_classifier_inferencing_categories = ei_classifier_inferencing_categories_791007_1;
const auto ei_dsp_blocks_size = ei_dsp_blocks_791007_1_size;
ei_model_dsp_t *ei_dsp_blocks = ei_dsp_blocks_791007_1;

#endif // _EI_CLASSIFIER_MODEL_VARIABLES_H_
