/*
 * Copyright (c) 2025 EdgeImpulse Inc.
 *
 * Generated by Edge Impulse and licensed under the applicable Edge Impulse
 * Terms of Service. Community and Professional Terms of Service
 * (https://edgeimpulse.com/legal/terms-of-service) or Enterprise Terms of
 * Service (https://edgeimpulse.com/legal/enterprise-terms-of-service),
 * according to your product plan subscription (the “License”).
 *
 * This software, documentation and other associated files (collectively referred
 * to as the “Software”) is a single SDK variation generated by the Edge Impulse
 * platform and requires an active paid Edge Impulse subscription to use this
 * Software for any purpose.
 *
 * You may NOT use this Software unless you have an active Edge Impulse subscription
 * that meets the eligibility requirements for the applicable License, subject to
 * your full and continued compliance with the terms and conditions of the License,
 * including without limitation any usage restrictions under the applicable License.
 *
 * If you do not have an active Edge Impulse product plan subscription, or if use
 * of this Software exceeds the usage limitations of your Edge Impulse product plan
 * subscription, you are not permitted to use this Software and must immediately
 * delete and erase all copies of this Software within your control or possession.
 * Edge Impulse reserves all rights and remedies available to enforce its rights.
 *
 * Unless required by applicable law or agreed to in writing, the Software is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing
 * permissions, disclaimers and limitations under the License.
 */
// Generated on: 30.09.2025 13:24:13

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#define STRINGIZE(x) #x
#define STRINGIZE_VALUE_OF(x) STRINGIZE(x)

#if defined (__GNUC__)  /* GNU compiler */
#define ALIGN(X) __attribute__((aligned(X)))
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (_MSC_VER)
#define ALIGN(X) __declspec(align(X))
#elif defined (__TASKING__) /* TASKING Compiler */
#define ALIGN(X) __align(X)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__ARMCC_VERSION) /* Arm Compiler */
#define ALIGN(X) __ALIGNED(x)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__ICCARM__) /* IAR Compiler */
#define ALIGN(x) __attribute__((aligned(x)))
#define DEFINE_SECTION(x) __attribute__((section(x)))
#elif defined (__clang__) /* LLVM/Clang Compiler */
#define ALIGN(X) __ALIGNED(x)
#define DEFINE_SECTION(x) __attribute__((section(x)))
#endif

#if defined(EI_MODEL_SECTION) && (defined(__GNUC__) || defined(__clang__))
#define MODEL_SECTION(X) __attribute__((section(STRINGIZE_VALUE_OF(X))))
#else
#define MODEL_SECTION(X)
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 8
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 1904;
#else
constexpr int kTensorArenaSize = 880;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
#if defined (EI_TENSOR_ARENA_LOCATION)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) DEFINE_SECTION(STRINGIZE_VALUE_OF(EI_TENSOR_ARENA_LOCATION));
#else
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#endif
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};

enum used_operators_e {
  OP_FULLY_CONNECTED, OP_SUB, OP_MUL, OP_RESHAPE, OP_SUM, OP_ADD, OP_REDUCE_MAX, OP_EXP, OP_LOG, OP_DIV, OP_ABS,  OP_LAST
};

struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 3;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 3;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

namespace g0 {
const TfArray<2, int> tensor_dimension0 = { 2, { 1,19 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) float tensor_data1[19] = { 68.786285400390625, 14.054512023925781, 36.867076873779297, 52.941909790039062, 47.38323974609375, 66.069931030273438, 47.636882781982422, 19.310581207275391, 42.888080596923828, 69.768142700195312, -32.773773193359375, 67.510025024414062, 28.071010589599609, 15.813697814941406, -1.114013671875, -26.3355712890625, -8.076385498046875, -15.259307861328125, 19.776569366455078, };
const TfArray<1, int> tensor_dimension1 = { 1, { 19 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(8) int32_t tensor_data2[2] = { 1, 1, };
const TfArray<1, int> tensor_dimension2 = { 1, { 2 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) int32_t tensor_data3[1] = { 1, };
const TfArray<1, int> tensor_dimension3 = { 1, { 1 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) int32_t tensor_data4[1] = { 2, };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(8) int32_t tensor_data5[3] = { 1, 1, 19, };
const TfArray<1, int> tensor_dimension5 = { 1, { 3 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(16) float tensor_data6[19*19] = { 
  70.121452331542969, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  7.1185688972473145, 8.6106472015380859, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  -49.234676361083984, -1.865237832069397, 88.961860656738281, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  1.3552993535995483, 1.8336224555969238, -4.8526434898376465, 56.281497955322266, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  19.513980865478516, 0.70852434635162354, 11.830795288085938, 7.9603543281555176, 10.360014915466309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  9.3696966171264648, -1.1005111932754517, 16.456411361694336, -26.894241333007812, -0.075557902455329895, 69.5697021484375, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  4.8443613052368164, -0.92015647888183594, 7.3103446960449219, 9.8453092575073242, 0.23655979335308075, 20.260570526123047, 8.7219085693359375, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  30.29658317565918, -0.077592454850673676, -40.672328948974609, 9.7561101913452148, 0.050899412482976913, 10.40669059753418, 2.1930820941925049, 10.29521369934082, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  22.004541397094727, 2.2895090579986572, -30.883039474487305, 1.5015686750411987, 0.46124342083930969, -15.202408790588379, 1.2959762811660767, -0.0093842949718236923, 62.938552856445312, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  45.037036895751953, -0.62691658735275269, -28.221572875976562, 9.0738039016723633, 0.71578013896942139, 32.287017822265625, 0.56856614351272583, 2.0378632545471191, 10.046736717224121, 2.8357150554656982, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  -27.903966903686523, -1.2695769071578979, 17.447111129760742, -15.682757377624512, -1.7796636819839478, -11.754937171936035, -1.8833712339401245, -3.3199417591094971, 11.201102256774902, -16.235815048217773, 19.835960388183594, 0, 0, 0, 0, 0, 0, 0, 0, 
  31.571540832519531, 0.20115567743778229, 2.8446385860443115, -2.4890339374542236, 1.5045813322067261, 24.618736267089844, 0.2300020307302475, -0.56018960475921631, 11.059030532836914, -246.53190612792969, -12.529548645019531, 257.02133178710938, 0, 0, 0, 0, 0, 0, 0, 
  13.749261856079102, -2.3844494819641113, 21.802499771118164, -23.212051391601562, 2.4685900211334229, -3.8564097881317139, 0.83371412754058838, -0.36297550797462463, 19.770435333251953, -157.58712768554688, -38.873725891113281, 136.80308532714844, 65.389411926269531, 0, 0, 0, 0, 0, 0, 
  9.956782341003418, -1.2063443660736084, 1.3281580209732056, -6.1020030975341797, -1.4313591718673706, 9.235316276550293, -1.3924422264099121, -0.48589062690734863, 5.3191342353820801, 296.50173950195312, -12.091259002685547, -736.1253662109375, 4.9405865669250488, 445.34844970703125, 0, 0, 0, 0, 0, 
  9.5045413970947266, -1.8670469522476196, -11.520540237426758, -1.8724976778030396, -4.4564623832702637, 9.289057731628418, -3.2795929908752441, 0.12123110890388489, 1.0559309720993042, 149.59283447265625, -5.9506430625915527, -85.436111450195312, -4.7134828567504883, -598.8568115234375, 542.8585205078125, 0, 0, 0, 0, 
  -27.283618927001953, -0.31422096490859985, 21.350658416748047, -4.8548717498779297, 1.4051178693771362, -5.9817395210266113, 0.32758089900016785, -3.7305281162261963, -8.1655092239379883, 25.455699920654297, 52.867462158203125, -64.103309631347656, -69.978713989257812, -103.86583709716797, 120.47615814208984, 43.368587493896484, 0, 0, 0, 
  7.2003374099731445, -2.2009966373443604, -13.353638648986816, 0.13976274430751801, -4.7937536239624023, 8.2738513946533203, -3.6276745796203613, -0.19100396335124969, -1.836980938911438, -122.62090301513672, 13.275673866271973, 111.21813201904297, -22.337888717651367, -4.5880188941955566, -531.77783203125, 14.726802825927734, 543.2164306640625, 0, 0, 
  -21.748382568359375, 2.3632416725158691, 2.1032648086547852, 8.657470703125, -0.43534794449806213, 2.5358262062072754, 0.24071632325649261, -2.0859973430633545, -7.1937227249145508, 117.15022277832031, -142.23146057128906, 44.551959991455078, 283.619873046875, -6.366304874420166, -86.990684509277344, -310.89892578125, -83.521163940429688, 187.92385864257812, 0, 
  28.271177291870117, 1.6540809869766235, 6.9693508148193359, -9.0648622512817383, 7.1633248329162598, -22.724382400512695, 2.5048871040344238, -0.086459875106811523, 7.5345458984375, 53.701808929443359, 141.95814514160156, -71.088424682617188, -268.65554809570312, -87.717750549316406, -40.100170135498047, 488.63067626953125, 97.45697021484375, -433.451171875, 127.74155426025391, 
};
const TfArray<2, int> tensor_dimension6 = { 2, { 19,19 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) float tensor_data7[1*1] = { 
  76.450065612792969, 
};
const TfArray<2, int> tensor_dimension7 = { 2, { 1,1 } };
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) float tensor_data8[1*1] = { 
  3.7961676120758057, 
};
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) float tensor_data9[1*1] = { 
  51.093746185302734, 
};
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) float tensor_data10[1*1] = { 
  -0.5, 
};
const MODEL_SECTION(EI_MODEL_SECTION) ALIGN(4) float tensor_data11[1*1] = { 
  34.919662475585938, 
};
const TfArray<3, int> tensor_dimension15 = { 3, { 1,1,19 } };
const TfLiteFullyConnectedParams opdata0 = { kTfLiteActNone, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs0 = { 3, { 0,6,-1 } };
const TfArray<1, int> outputs0 = { 1, { 12 } };
const TfLiteSubParams opdata1 = { kTfLiteActNone };
const TfArray<2, int> inputs1 = { 2, { 12,1 } };
const TfArray<1, int> outputs1 = { 1, { 13 } };
const TfLiteMulParams opdata2 = { kTfLiteActNone };
const TfArray<2, int> inputs2 = { 2, { 13,13 } };
const TfArray<1, int> outputs2 = { 1, { 14 } };
const TfLiteReshapeParams opdata3 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs3 = { 2, { 14,5 } };
const TfArray<1, int> outputs3 = { 1, { 15 } };
const ALIGN(1) uint8_t opdata4[1] = { 0,  }; /* op type 74=SUM */
const TfArray<2, int> inputs4 = { 2, { 15,4 } };
const TfArray<1, int> outputs4 = { 1, { 16 } };
const TfLiteAddParams opdata5 = { kTfLiteActNone };
const TfArray<2, int> inputs5 = { 2, { 16,11 } };
const TfArray<1, int> outputs5 = { 1, { 17 } };
const TfLiteMulParams opdata6 = { kTfLiteActNone };
const TfArray<2, int> inputs6 = { 2, { 17,10 } };
const TfArray<1, int> outputs6 = { 1, { 18 } };
const TfLiteAddParams opdata7 = { kTfLiteActNone };
const TfArray<2, int> inputs7 = { 2, { 18,7 } };
const TfArray<1, int> outputs7 = { 1, { 19 } };
const ALIGN(1) uint8_t opdata8[1] = { 0,  }; /* op type 82=REDUCE_MAX */
const TfArray<2, int> inputs8 = { 2, { 19,3 } };
const TfArray<1, int> outputs8 = { 1, { 20 } };
const TfLiteReshapeParams opdata9 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs9 = { 2, { 20,2 } };
const TfArray<1, int> outputs9 = { 1, { 21 } };
const TfLiteSubParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 19,21 } };
const TfArray<1, int> outputs10 = { 1, { 22 } };
const TfArray<1, int> inputs11 = { 1, { 22 } };
const TfArray<1, int> outputs11 = { 1, { 23 } };
const ALIGN(1) uint8_t opdata12[1] = { 0,  }; /* op type 74=SUM */
const TfArray<2, int> inputs12 = { 2, { 23,3 } };
const TfArray<1, int> outputs12 = { 1, { 24 } };
const TfArray<1, int> inputs13 = { 1, { 24 } };
const TfArray<1, int> outputs13 = { 1, { 25 } };
const TfLiteAddParams opdata14 = { kTfLiteActNone };
const TfArray<2, int> inputs14 = { 2, { 25,20 } };
const TfArray<1, int> outputs14 = { 1, { 26 } };
const TfLiteReshapeParams opdata15 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs15 = { 2, { 26,2 } };
const TfArray<1, int> outputs15 = { 1, { 27 } };
const TfLiteSubParams opdata16 = { kTfLiteActNone };
const TfArray<2, int> inputs16 = { 2, { 27,9 } };
const TfArray<1, int> outputs16 = { 1, { 28 } };
const ALIGN(4) uint8_t opdata17[4] = { 0, 0, 0, 0,  }; /* op type 42=DIV */
const TfArray<2, int> inputs17 = { 2, { 28,8 } };
const TfArray<1, int> outputs17 = { 1, { 29 } };
const TfArray<1, int> inputs18 = { 1, { 29 } };
const TfArray<1, int> outputs18 = { 1, { 30 } };
};

TensorInfo_t tensorData[] = {
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension0, 76, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data1, (TfLiteIntArray*)&g0::tensor_dimension1, 76, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data2, (TfLiteIntArray*)&g0::tensor_dimension2, 8, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data3, (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data4, (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data5, (TfLiteIntArray*)&g0::tensor_dimension5, 12, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data6, (TfLiteIntArray*)&g0::tensor_dimension6, 1444, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data7, (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data8, (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data9, (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data10, (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteMmapRo, kTfLiteFloat32, (int32_t*)g0::tensor_data11, (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 80), (TfLiteIntArray*)&g0::tensor_dimension0, 76, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension0, 76, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 80), (TfLiteIntArray*)&g0::tensor_dimension0, 76, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension15, 76, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 80), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 48), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 32), (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension3, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
{ kTfLiteArenaRw, kTfLiteFloat32, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension7, 4, },
};

#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[19] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs4, (TfLiteIntArray*)&g0::outputs4, (TfLiteIntArray*)&g0::inputs4, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata4)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs5, (TfLiteIntArray*)&g0::outputs5, (TfLiteIntArray*)&g0::inputs5, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata5)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs6, (TfLiteIntArray*)&g0::outputs6, (TfLiteIntArray*)&g0::inputs6, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata6)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs7, (TfLiteIntArray*)&g0::outputs7, (TfLiteIntArray*)&g0::inputs7, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata7)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs8, (TfLiteIntArray*)&g0::outputs8, (TfLiteIntArray*)&g0::inputs8, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata8)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs9, (TfLiteIntArray*)&g0::outputs9, (TfLiteIntArray*)&g0::inputs9, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata9)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs10, (TfLiteIntArray*)&g0::outputs10, (TfLiteIntArray*)&g0::inputs10, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata10)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs11, (TfLiteIntArray*)&g0::outputs11, (TfLiteIntArray*)&g0::inputs11, nullptr, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs12, (TfLiteIntArray*)&g0::outputs12, (TfLiteIntArray*)&g0::inputs12, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata12)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs13, (TfLiteIntArray*)&g0::outputs13, (TfLiteIntArray*)&g0::inputs13, nullptr, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs14, (TfLiteIntArray*)&g0::outputs14, (TfLiteIntArray*)&g0::inputs14, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata14)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs15, (TfLiteIntArray*)&g0::outputs15, (TfLiteIntArray*)&g0::inputs15, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata15)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs16, (TfLiteIntArray*)&g0::outputs16, (TfLiteIntArray*)&g0::inputs16, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata16)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs17, (TfLiteIntArray*)&g0::outputs17, (TfLiteIntArray*)&g0::inputs17, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata17)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs18, (TfLiteIntArray*)&g0::outputs18, (TfLiteIntArray*)&g0::inputs18, nullptr, nullptr, nullptr, nullptr, 0, },
};
#else
TfLiteNode tflNodes[19] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs4, (TfLiteIntArray*)&g0::outputs4, (TfLiteIntArray*)&g0::inputs4, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata4)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs5, (TfLiteIntArray*)&g0::outputs5, (TfLiteIntArray*)&g0::inputs5, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata5)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs6, (TfLiteIntArray*)&g0::outputs6, (TfLiteIntArray*)&g0::inputs6, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata6)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs7, (TfLiteIntArray*)&g0::outputs7, (TfLiteIntArray*)&g0::inputs7, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata7)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs8, (TfLiteIntArray*)&g0::outputs8, (TfLiteIntArray*)&g0::inputs8, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata8)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs9, (TfLiteIntArray*)&g0::outputs9, (TfLiteIntArray*)&g0::inputs9, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata9)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs10, (TfLiteIntArray*)&g0::outputs10, (TfLiteIntArray*)&g0::inputs10, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata10)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs11, (TfLiteIntArray*)&g0::outputs11, (TfLiteIntArray*)&g0::inputs11, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs12, (TfLiteIntArray*)&g0::outputs12, (TfLiteIntArray*)&g0::inputs12, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata12)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs13, (TfLiteIntArray*)&g0::outputs13, (TfLiteIntArray*)&g0::inputs13, nullptr, nullptr, nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs14, (TfLiteIntArray*)&g0::outputs14, (TfLiteIntArray*)&g0::inputs14, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata14)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs15, (TfLiteIntArray*)&g0::outputs15, (TfLiteIntArray*)&g0::inputs15, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata15)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs16, (TfLiteIntArray*)&g0::outputs16, (TfLiteIntArray*)&g0::inputs16, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata16)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs17, (TfLiteIntArray*)&g0::outputs17, (TfLiteIntArray*)&g0::inputs17, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata17)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs18, (TfLiteIntArray*)&g0::outputs18, (TfLiteIntArray*)&g0::inputs18, nullptr, nullptr, nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_FULLY_CONNECTED, OP_SUB, OP_MUL, OP_RESHAPE, OP_SUM, OP_ADD, OP_MUL, OP_ADD, OP_REDUCE_MAX, OP_RESHAPE, OP_SUB, OP_EXP, OP_SUM, OP_LOG, OP_ADD, OP_RESHAPE, OP_SUB, OP_DIV, OP_ABS, };


// Indices into tflTensors and tflNodes for subgraphs
const size_t tflTensors_subgraph_index[] = {0, 31, };
const size_t tflNodes_subgraph_index[] = {0, 19, };

// Input/output tensors
static const int in_tensor_indices[] = {
  0, 
};

static const int out_tensor_indices[] = {
  30, 
};


size_t current_subgraph_index = 0;

static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = false;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization.type = kTfLiteNoQuantization;

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}

typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;

static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
 
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  }

  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }

  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }
 
  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }

  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }

  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }

};


} // namespace

TfLiteStatus tflite_anomaly_791007_6_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  
  // Set microcontext as the context ptr
  ctx.impl_ = static_cast<void*>(&micro_context_);
  // Setup tflitecontext functions
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;

  ctx.tensors_size = 31;
  for (size_t i = 0; i < 31; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }

  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }

  registrations[OP_FULLY_CONNECTED] = Register_FULLY_CONNECTED();
  registrations[OP_SUB] = Register_SUB();
  registrations[OP_MUL] = Register_MUL();
  registrations[OP_RESHAPE] = Register_RESHAPE();
  registrations[OP_SUM] = Register_SUM();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_REDUCE_MAX] = Register_REDUCE_MAX();
  registrations[OP_EXP] = Register_EXP();
  registrations[OP_LOG] = Register_LOG();
  registrations[OP_DIV] = Register_DIV();
  registrations[OP_ABS] = Register_ABS();

  for (size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].init) {
        tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
      }
    }
  }
  current_subgraph_index = 0;

  for(size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].prepare) {
        ResetTensors();
        TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
        if (status != kTfLiteOk) {
          return status;
        }
      }
    }
  }
  current_subgraph_index = 0;

  return kTfLiteOk;
}

TfLiteStatus tflite_anomaly_791007_6_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(in_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_anomaly_791007_6_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(out_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_anomaly_791007_6_invoke() {
  for (size_t i = 0; i < 19; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_anomaly_791007_6_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
