// Arduino Code for Laptop-Based HMI for DC Motor Speed and Direction Control
// Author: Pradipta Ghosh

int val;
int IN1 = 9;
int IN2 = 11;
int EN = 13;

boolean forward = false;
boolean _stop = false;
boolean reverse = false;

void setup() 
{
  pinMode(IN1,OUTPUT);
  pinMode(IN2,OUTPUT);
  pinMode(EN,OUTPUT);
  Serial.begin(9600);
  digitalWrite(EN, HIGH);

  digitalWrite(IN1, LOW);
  analogWrite(IN2, 0);
}

void loop() 
{
  if(Serial.available())
  {
  val = Serial.read();
  if (val == 0)
 {
   forward = true;
   _stop = false;
   reverse = false;
   Serial.println("Direction: FORWARD");
 }
 if (val == 1)
 {
   forward = false;
   _stop = true;
   reverse = false;
   Serial.println("Motor STOPPED");
 }
 if (val == 2)
 {
   forward = false;
   _stop = false;
   reverse = true;
   Serial.println("Direction: REVERSE");
 }

  if((forward && !_stop && !reverse) && ( val > 2 && val <= 255))
  {
   digitalWrite(IN1, LOW);
   analogWrite(IN2, val);
   Serial.print("Speed set to: ");
   Serial.println(val);
  }

  if(!forward && _stop && !reverse)
  {
   digitalWrite(IN1, LOW);
   digitalWrite(IN2, LOW);
  }
 if((!forward && !_stop && reverse) && ( val > 2 && val <= 255))
  {
   analogWrite(IN1, val);
   digitalWrite(IN2, LOW);
   Serial.print("Speed set to: ");
   Serial.println(val);
  }
  }
}
 