#include <DHT11.h>
#include <TFT.h>  
#include <SPI.h>
#include <Wire.h>
#include <RTClib.h>

RTC_DS1307 rtc;
DFRobot_DHT11 DHT;
#define DHT11_PIN 2
#define cs   10
#define dc   9
#define rst  8

// create an instance of the library
TFT TFTscreen = TFT(cs, dc, rst);
String hr_str, min_str,sec_str,tmp_str,hum_str;
char hour_str[3],minut_str[3],second_str[3],temp[3],hum[3];

void setup() 
{
  TFTscreen.begin();
  TFTscreen.background(0, 0, 0);
  TFTscreen.setTextSize(2);  
  TFTscreen.stroke(0,255,0);  
  TFTscreen.text("TIME", 50, 5); 
  TFTscreen.stroke(0,0,255);  
  TFTscreen.line(48,23,108,23);  
  TFTscreen.stroke(255,0,0); 
  TFTscreen.rect(5,27,145,30); 
  TFTscreen.stroke(0,255,255);  
  TFTscreen.line(82,64,82,125);   
  TFTscreen.stroke(0,255,0);  
  TFTscreen.text("Temp", 25, 64); 
  TFTscreen.stroke(255,0,255);  
  TFTscreen.text("Humi", 95, 64); 
  TFTscreen.stroke(0,150,200);  
  TFTscreen.text("o", 68, 82);
  TFTscreen.setTextSize(3);   
  TFTscreen.text("C", 65, 102);  
  TFTscreen.text("%", 145, 95);   
  Serial.begin(9600);  
  if (! rtc.begin()) 
  {
    Serial.println("Couldn't find RTC");
    //while (1);
  }
  if (! rtc.isrunning())
  {
    Serial.println("RTC is NOT running!");
  }
}

void loop() 
 {
  int red = random(0, 255);
  int green = random (0, 255);
  int blue = random (0, 255);
  TFTscreen.setTextSize(3);  
  DateTime now = rtc.now();   
  hr_str = String(now.hour());
  hr_str.toCharArray(hour_str,3);  
  min_str = String(now.minute());
  min_str.toCharArray(minut_str,3); 
  sec_str = String(now.second());
  sec_str.toCharArray(second_str,3);   
  TFTscreen.stroke(red,green,blue);  
  TFTscreen.text(hour_str, 10, 30);  
  TFTscreen.text(":", 45, 30);  
  TFTscreen.text(minut_str, 60, 30); 
  TFTscreen.text(":", 95, 30);  
  TFTscreen.text(second_str, 110, 30);
  DHT.read(DHT11_PIN);
  tmp_str = String(DHT.temperature);
  tmp_str.toCharArray(temp,3);
  hum_str = String(DHT.humidity);
  hum_str.toCharArray(hum,3);
  TFTscreen.setTextSize(5);  
  TFTscreen.stroke(0,0,255);  
  TFTscreen.text(temp,8,85); 
  TFTscreen.stroke(255,255,0);  
  TFTscreen.text(hum, 88, 85); 
  delay(2800);    
  TFTscreen.stroke(0,0,0);
  TFTscreen.setTextSize(3);  
  TFTscreen.text(hour_str,10,30); 
  TFTscreen.text(minut_str,60,30);  
  TFTscreen.text(second_str,110,30);
  TFTscreen.setTextSize(5);  
  TFTscreen.text(temp,8,85);  
  TFTscreen.text(hum,88,85);   
  delay(200);    
 }
