//RAKESH JAIN PROGRAM FOR "Colour Buddy: Learn Colours with Lights"
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Wire.h>
// OLED settings
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
// RGB LED pins
int redPin = 9;
int greenPin = 10;
int bluePin = 11;
// Define structure for color
struct Color {
  byte r, g, b;
  const char* name;
};
// Updated and more visible color list
Color colors[] = {
  {255, 0, 0, "Red"},
  {0, 255, 0, "Green"},
  {0, 0, 255, "Blue"},
  {255, 255, 0, "Yellow"},
  {255, 165, 0, "Orange"},
  {255, 20, 147, "Pink"},
  {0, 255, 255, "Cyan"},
  {255, 255, 255, "White"},
  {0, 0, 0, "Black"},                    // Will not light up LED means showing darkness
  {128, 0, 128, "Purple"},
  {128, 0, 0, "Maroon"},
  {0, 0, 128, "Navy"},
  {128, 128, 128, "Gray"},
  {173, 216, 230, "Light Blue"},
};

int numColors = sizeof(colors) / sizeof(colors[0]);
int currentIndex = 0;
void setup() {
  pinMode(redPin, OUTPUT);
  pinMode(greenPin, OUTPUT);
  pinMode(bluePin, OUTPUT);
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    while (true); // OLED not found
  }
  display.clearDisplay();
  display.display();
}
void loop() {
  Color c = colors[currentIndex];
  // Smart LED handling: skip black from LED
  if (c.r == 0 && c.g == 0 && c.b == 0) {
    analogWrite(redPin, 0);
    analogWrite(greenPin, 0);
    analogWrite(bluePin, 0);
  } else {
    analogWrite(redPin, c.r);
    analogWrite(greenPin, c.g);
    analogWrite(bluePin, c.b);
  }
  // OLED display
  display.clearDisplay();
  display.setTextColor(SSD1306_WHITE);
  display.setTextSize(1);
  display.setCursor(0, 10);
  display.print("Current Color:");
  display.setTextSize(2);
  display.setCursor(0, 30);
  display.print(c.name);
  display.display();
  delay(5000);  // Wait 5 seconds
  // Move to next color
  currentIndex = (currentIndex + 1) % numColors;
}