#include <Wire.h>
struct UltrasonicSensor {
  int trigPin;
  int echoPin;
};
UltrasonicSensor sensors[4] = {
  {2, 3}, {4, 5}, {6, 7}, {8, 9}
};
const int detectionThreshold = 15; // cm
const int I2C_ADDRESS = 8;
unsigned long lastPrintTime = 0;
const unsigned long printInterval = 1000; // 1 second
void setup() {
  Wire.begin(I2C_ADDRESS);
  Wire.onRequest(sendSensorStatus);
  Serial.begin(9600);
  for (int i = 0; i < 4; i++) {
    pinMode(sensors[i].trigPin, OUTPUT);
    pinMode(sensors[i].echoPin, INPUT);
  }
  Serial.println("Ultrasonic Sensor Debug Mode: Active");
}
void loop() {
  // Print distances every second
  if (millis() - lastPrintTime >= printInterval) {
    lastPrintTime = millis();
    Serial.println("Sensor Distances (in cm):");
    for (int i = 0; i < 4; i++) {
      long distance = getDistance(sensors[i].trigPin, sensors[i].echoPin);
      Serial.print("Lane ");
      Serial.print(i + 1);
      Serial.print(": ");
      if (distance < 0) {
        Serial.println("Out of range");
      } else {
        Serial.print(distance);
        Serial.println(" cm");
      }
    }
    Serial.println("----------------------");
  }
  delay(10); // prevent overload
}

void sendSensorStatus() {
  byte status = 0;
  for (int i = 0; i < 4; i++) {
    long distance = getDistance(sensors[i].trigPin, sensors[i].echoPin);
    if (distance > 0 && distance < detectionThreshold) {
      bitSet(status, i);
    }
  }


  Wire.write(status);
}
long getDistance(int trig, int echo) {
  digitalWrite(trig, LOW);
  delayMicroseconds(2);
  digitalWrite(trig, HIGH);
  delayMicroseconds(10);
  digitalWrite(trig, LOW);
  long duration = pulseIn(echo, HIGH, 25000); // 25 ms timeout
  return (duration == 0) ? -1 : duration * 0.034 / 2;
}



