#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>

// WiFi credentials
const char* ssid = "vivo";
const char* password = "muru555999";

// Firebase credentials
#define DATABASE_URL "https://esp32camsecurity-default-rtdb.asia-southeast1.firebasedatabase.app/"
#define API_KEY "AIzaSyCtkhhd_AuunnmePvratW6Wk_vSVfAbtPU"

// Relay Pins
#define IMPORTANT_LOAD_RELAY_PIN D1
#define UNIMPORTANT_LOAD_RELAY_PIN D2

FirebaseData firebaseData;
FirebaseAuth auth;
FirebaseConfig config;

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("Connecting");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(1000);
  }
  Serial.println("\nConnected to WiFi!");

  config.api_key = API_KEY;
  config.database_url = DATABASE_URL;
  Firebase.begin(&config, &auth);
  Firebase.reconnectWiFi(true);

  pinMode(IMPORTANT_LOAD_RELAY_PIN, OUTPUT);
  pinMode(UNIMPORTANT_LOAD_RELAY_PIN, OUTPUT);
  digitalWrite(IMPORTANT_LOAD_RELAY_PIN, HIGH);     // OFF (NC relay)
  digitalWrite(UNIMPORTANT_LOAD_RELAY_PIN, HIGH);   // OFF
}

void loop() {
  float frequency = 50.0;
  bool frequencyFault = false;
  String faultReason = "";

  // Read frequency
  if (Firebase.getFloat(firebaseData, "/SmartGrid/Generation/Frequency")) {
    frequency = firebaseData.floatData();
    Serial.print("Frequency: "); Serial.println(frequency);

    if (frequency < 45.0) {
      frequencyFault = true;
      faultReason = "Under Frequency";
    } else if (frequency > 51.0) {
      frequencyFault = true;
      faultReason = "Over Frequency";
    }
  } else {
    Serial.println("Failed to read frequency.");
  }

  // Act based on fault status
  if (frequencyFault) {
    digitalWrite(IMPORTANT_LOAD_RELAY_PIN, HIGH);   // OFF
    digitalWrite(UNIMPORTANT_LOAD_RELAY_PIN, HIGH); // OFF

    // Upload fault reason
    if (Firebase.setString(firebaseData, "/SmartGrid/Fault/Reason", faultReason)) {
      Serial.println("Fault Reason updated in Firebase: " + faultReason);
    } else {
      Serial.println("Failed to upload fault reason.");
    }

  } else {
    // Clear previous fault reason
    Firebase.setString(firebaseData, "/SmartGrid/Fault/Reason", "None");

    // Read relay states
    int impState = 0, unimpState = 0;
    if (Firebase.getInt(firebaseData, "/SmartGrid/Remote_Control/Important_Load_Relay")) {
      impState = firebaseData.intData();
    }
    if (Firebase.getInt(firebaseData, "/SmartGrid/Remote_Control/Unimportant_Load_Relay")) {
      unimpState = firebaseData.intData();
    }

    digitalWrite(IMPORTANT_LOAD_RELAY_PIN, impState == 1 ? LOW : HIGH);
    digitalWrite(UNIMPORTANT_LOAD_RELAY_PIN, unimpState == 1 ? LOW : HIGH);
  }

  delay(2000);
}

