#include <Wire.h>
#include "MAX30100_PulseOximeter.h"

#ifdef ESP8266
#include <ESP8266WiFi.h>
#elif defined(ESP32)
#include <WiFi.h>
#endif

#include <AsyncTelegram2.h>

WiFiClientSecure client;
AsyncTelegram2 myBot(client);

// === YOUR SETTINGS ===
const char* ssid = "IRONMAN";
const char* pass = "1234567890";
const char* token = "5170313679:AAEZDcnKskxjhrD4V8fayYvChlQtzXTpztc";  // Your bot token
int64_t chat_id = 1234567890;  // ← CHANGE TO YOUR REAL CHAT ID (use @userinfobot to get it)

#define REPORTING_PERIOD_MS     1000

PulseOximeter pox;
uint32_t tsLastReport = 0;

unsigned long lastTelegramReport = 0;
const unsigned long telegramInterval = 10000;  // Send every 10 seconds (change as needed)

void onBeatDetected() {
  Serial.println("Beat!");
}

String getHealthReport() {
  float hr = pox.getHeartRate();
  float spo2 = pox.getSpO2();

  if (hr > 30 && spo2 > 70) {
    char msg[200];
    snprintf(msg, sizeof(msg),
             "❤️ Health Update\n"
             "Heart Rate: %.1f bpm\n"
             "SpO₂: %.0f %%\n"
             "Status: Normal",
             hr, spo2);
    return String(msg);
  } else {
    return "⚠️ No valid reading yet\nPlease place finger gently on sensor";
  }
}

void setup() {
  Serial.begin(115200);
  delay(1000);

  // 1. Connect to WiFi first
  Serial.print("Connecting to WiFi ");
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nWiFi Connected!");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

  // 2. Setup secure client for Telegram (ESP32)
#ifdef ESP32
  client.setCACert(telegram_cert);  // Root CA for api.telegram.org
#endif
#ifdef ESP8266
  client.setInsecure();  // ESP8266 handles differently
#endif

  // 3. Connect to Telegram
  myBot.setTelegramToken(token);
  Serial.print("Connecting to Telegram Bot...");
  if (myBot.begin()) {
    Serial.println("Telegram Bot Connected!");
  } else {
    Serial.println("Telegram Bot Connection FAILED!");
  }

  // Startup message
  String startMsg = "Health Monitor Started\n"
                    "WiFi: Connected\n"
                    "Telegram: Connected\n"
                    "Sensor: Initializing...";
  myBot.sendTo(chat_id, startMsg.c_str());
  Serial.println("Startup message sent to Telegram");

  // 4. Initialize MAX30100 sensor (after connections)
  Serial.print("Initializing pulse oximeter..");
  if (!pox.begin()) {
    Serial.println("FAILED");
    for(;;);
  } else {
    Serial.println("SUCCESS");
  }
  pox.setOnBeatDetectedCallback(onBeatDetected);
}

void loop() {
  // Update sensor
  pox.update();

  // Print to Serial every 1 second (your original code)
  if (millis() - tsLastReport > REPORTING_PERIOD_MS) {
    float hr = pox.getHeartRate();
    float spo2 = pox.getSpO2();

    Serial.print("Heart rate:");
    Serial.print(hr);
    Serial.print(" bpm / SpO2:");
    Serial.print(spo2);
    Serial.println(" %");
     String report = getHealthReport();
    myBot.sendTo(chat_id, report.c_str());
    Serial.println("Health report sent to Telegram");
    tsLastReport = millis();
  }


  // Handle incoming commands
  TBMessage msg;
  if (myBot.getNewMessage(msg)) {
    String text = msg.text;
    text.toLowerCase();

    if (text.indexOf("how are you") != -1 ||
        text.indexOf("health") != -1 ||
        text.indexOf("data") != -1 ||
        text.indexOf("status") != -1 ||
        text.indexOf("get data") != -1) {

      String report = getHealthReport();
      myBot.sendMessage(msg, report.c_str());
      Serial.println("Health report sent on command");
    } else {
      myBot.sendMessage(msg, "Send 'health' or 'data' for current reading");
    }
  }
}