#include <Adafruit_Fingerprint.h>
#include <SoftwareSerial.h>
SoftwareSerial mySerial(10, 11); // RX, TX for fingerprint
Adafruit_Fingerprint finger = Adafruit_Fingerprint(&mySerial);
String userNames[15] = {
  "Rakesh Jain",  // ID 1 - Admin
  "Anil",         // ID 2
  "Gunmala",      // ID 3
  "Rekha",        // ID 4
  "Monu",         // ID 5
  "Niket",        // ID 6
  "Garima",       // ID 7
  "Sonu",         // ID 8
  "Neetu",        // ID 9
  "Tinu",         // ID 10
  "Vikas",        // ID 11
  "Chintu",       // ID 12
  "Sarita",       // ID 13
  "Harita",       // ID 14
  "Deepak"        // ID 15
};
void setup() {
  Serial.begin(9600);
  while (!Serial);
  finger.begin(57600);
  if (finger.verifyPassword()) {
    Serial.println("Fingerprint sensor ready");
  } else {
    Serial.println("Fingerprint sensor not found");
    while (1);
  }

  Serial.println("Enter ID (1–15) to enroll:");
}
void loop() {
  while (!Serial.available());
  int id = Serial.parseInt();
  if (id < 1 || id > 15) {
    Serial.println("Invalid ID. Enter 1–15.");
    return;
  }
  Serial.print("Enrolling for: ");
  Serial.println(userNames[id - 1]);
  enrollFingerprint(id);
}
void enrollFingerprint(int id) {
  int p = -1;
  Serial.println("Place finger to enroll...");
  while (p != FINGERPRINT_OK) {
    p = finger.getImage();
  }
  p = finger.image2Tz(1);
  if (p != FINGERPRINT_OK) {
    Serial.println("Error processing first image");
    return;
  }
  Serial.println("Remove finger...");
  delay(2000);
  while (finger.getImage() != FINGERPRINT_NOFINGER);
  Serial.println("Place same finger again...");
  p = -1;
  while (p != FINGERPRINT_OK) {
    p = finger.getImage();
  }
  p = finger.image2Tz(2);
  if (p != FINGERPRINT_OK) {
    Serial.println("Error processing second image");
    return;
  }
  p = finger.createModel();
  if (p != FINGERPRINT_OK) {
    Serial.println("Could not create model");
    return;
  }
  p = finger.storeModel(id);
  if (p == FINGERPRINT_OK) {
    Serial.print("Enrolled successfully for: ");
    Serial.println(userNames[id - 1]);
  } else {
    Serial.println("Enrollment failed");
  }
}
