 // Over current /IDMT(Inverse definite minimum time)relay based on Arduino Nano and Current sensor ACS712.
// Written by P.Balasubramanian. 24.5.2025


#include "ACS712.h"
ACS712 sensor( ACS712_30A, A0); //ACS712_05B for 5 Amp type, ACS712_20A for 20 Amp type, ACS712_30A for 30 Amp type

#include <elapsedMillis.h>
elapsedMillis timeElapsed;

int OLR = 12;
int resetbutton = 11;
float Is = 1.05 * 6.00;  // current setting of relay x full load current of motor/feeder, in terms of CT primary current.
float psm;      // Plug setting multipier.
float tsm = 1.00;// Time setting multiplier, can be changed to get different inverse curves.
float lookupI[] = {1.00, 1.10, 1.20, 1.30, 1.40, 1.50, 1.60, 1.70, 1.80, 1.90, 2.00, 2.10, 2.20, 2.30, 2.40, 2.50, 2.60, 2.70, 2.80, 2.90, 3.00, 4.00, 5.00, 6.00, 7.00, 8.00, 9.00, 10.00 };
int lookupT[] = {254,117, 98, 69, 52, 45, 38, 34, 31, 28, 28, 25, 25, 22, 19, 16, 13, 9, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3};
int x, m, s, resetbutton1 ;
float Y, I, CTR = 6.00;


void setup()
{
  pinMode(OLR, OUTPUT);
  pinMode(resetbutton, INPUT_PULLUP);
  Serial.begin(9600);
  sensor.calibrate();
}

void loop()
{
  {
    I = sensor.getCurrentAC();
    //ignoring the value below 0.09
    if (I < 0.09) {
      I = 0;
    }
    Serial.println(I);
    delay(300);
  }
  resetbutton1 = digitalRead (resetbutton);
  psm = I * CTR / Is; // calculate the plug setting multiplier.
  // Serial.println(psm);
  for ( x = 0; lookupI[x] < psm; x++) {

  }// count and find out the order of the number which closely match with the psm vaue on the lookupI table.
  // Serial.println(x );

  Y = ((lookupT [x] ) * tsm) ;// load the timing value to  variable "Y" from the lookupT table, corresponding to the psm value.

  // ON delay timer.
  if ( psm >= 1.00)
  {
    if (timeElapsed > Y * 1000) {
      m = HIGH ;
    }
    else if (timeElapsed <= Y * 1000) {
      m = LOW ;
    }
  }
  else if ( psm < 1.00)
  {
    m = LOW ;
    timeElapsed = 0;
  }
  // OLR/IDMT relay sealing and reset.
  if ((m == HIGH || s == HIGH) && resetbutton1 == HIGH) {
    s = HIGH;
    digitalWrite(OLR, s);
  }
  else {
    s = LOW;
    digitalWrite(OLR, s);
  }
}
