#include <ESP32Servo.h>

// Servo pin (change if needed)
const int servoPin = 4;
Servo myServo;

void setup() {
  Serial.begin(115200);  // USB Serial for WebSerial
  myServo.attach(servoPin);
  myServo.write(90);     // Start at center
  Serial.println("Servo ready - waiting for commands...");
}

void loop() {
  if (Serial.available() > 0) {
    String command = Serial.readStringUntil('\n');
    command.trim();
    
    if (command.startsWith("angle:")) {
      String valStr = command.substring(6);
      int angle = valStr.toInt();
      angle = constrain(angle, 0, 180);
      myServo.write(angle);
      Serial.print("Set servo to: ");
      Serial.println(angle);
    }
  }
  delay(10);  // Small delay for stability
}
